/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report;

import com.fasterxml.jackson.databind.JsonNode;
import com.gso.finance.report.MainReport;
import com.gso.finance.report.block.CashAccountsDetails;
import com.gso.finance.report.block.PositionsDetails;
import com.gso.finance.report.config.ReportsConfiguration;
import com.gso.finance.report.header.DefaulPortfolioHeader;
import com.gso.finance.report.model.Portfolio;
import com.gso.finance.report.model.ReportInformation;
import com.gso.finance.util.rabbitmq.RabbitController;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.AreaBreak;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.AreaBreakType;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class MainSummaryReport
implements MainReport {
    @Override
    public String generateReport(JsonNode data) {
        Portfolio portfolio = new Portfolio(data.get("portfolio"));
        ReportInformation report = new ReportInformation(data.get("report"));
        String documentPath = "";
        try {
            ReportsConfiguration configuration = RabbitController.getInstance().getReportsConfiguration();
            documentPath = String.valueOf(configuration.getWorkingPath()) + portfolio.getName().replace('/', '-').replace('\\', '-') + ".pdf";
            FileOutputStream fos = new FileOutputStream(documentPath);
            PdfWriter writer = new PdfWriter((OutputStream)fos);
            PdfFont defaultFont = PdfFontFactory.createFont((String)(String.valueOf(configuration.getResourcesPath()) + configuration.getDefaultFont()));
            PdfDocument pdf = new PdfDocument(writer);
            Document document = new Document(pdf, PageSize.A4.rotate());
            document.setFont(defaultFont);
            document.setMargins(15.0f, 15.0f, 15.0f, 15.0f);
            Table header = new DefaulPortfolioHeader(configuration, report, portfolio, "Portfolio Summary").getHeader();
            document.add((BlockElement)header);
            document.add((BlockElement)new CashAccountsDetails(configuration, portfolio, "ACCOUNTS", false).getDetailsTable(portfolio.getSubPortfolios().length > 0));
            if (portfolio.getCurrentPositions().length > 0) {
                ArrayList<Table> tables = new PositionsDetails(configuration, portfolio, "POSITIONS").getDetailsTables();
                for (Table table : tables) {
                    document.add(new AreaBreak(AreaBreakType.NEXT_PAGE));
                    document.add((BlockElement)header);
                    document.add((BlockElement)table);
                }
            }
            document.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return documentPath;
    }
}

