/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report;

import com.fasterxml.jackson.databind.JsonNode;
import com.gso.finance.report.MainReport;
import com.gso.finance.report.config.ReportsConfiguration;
import com.gso.finance.report.header.SimplePortfoliotHeader;
import com.gso.finance.report.model.Operation;
import com.gso.finance.report.model.Portfolio;
import com.gso.finance.report.model.ReportInformation;
import com.gso.finance.util.rabbitmq.RabbitController;
import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.border.SolidBorder;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.TextAlignment;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;

public class OperationAMLReport
implements MainReport {
    @Override
    public String generateReport(JsonNode data) {
        Portfolio portfolio = new Portfolio(data.get("portfolio"));
        Operation operation = new Operation(data.get("operation"));
        ReportInformation report = new ReportInformation(data.get("report"));
        String documentPath = "";
        Calendar operationCalendar = Calendar.getInstance();
        operationCalendar.setTime(operation.getValueDate());
        try {
            ReportsConfiguration configuration = RabbitController.getInstance().getReportsConfiguration();
            documentPath = String.valueOf(configuration.getWorkingPath()) + "OPERATION_AML_" + operation.getId() + ".pdf";
            FileOutputStream fos = new FileOutputStream(documentPath);
            PdfWriter writer = new PdfWriter((OutputStream)fos);
            PdfFont defaultFont = PdfFontFactory.createFont((String)(String.valueOf(configuration.getResourcesPath()) + configuration.getDefaultFont()));
            PdfDocument pdf = new PdfDocument(writer);
            Document document = new Document(pdf, PageSize.A4);
            document.setFont(defaultFont);
            document.setMargins(15.0f, 15.0f, 15.0f, 15.0f);
            Table header = new SimplePortfoliotHeader(configuration, report, portfolio, "OPERATION AML").getHeader();
            document.add((BlockElement)header);
            Table operationName = this.getSingleRowTextTable();
            operationName.addCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setUnderline()).setBold()).add((BlockElement)new Paragraph(operation.getName())));
            operationName.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).add((BlockElement)new Paragraph("Amount (" + portfolio.getManagementCompany().getCurrencyCode() + "): " + configuration.getAmountFormatter().format(operation.getAmountManagement()))));
            document.add((BlockElement)operationName);
            Table summaryTable = this.getTwoColsTable(0.4f);
            summaryTable.addCell(((Cell)((Cell)new Cell().setBorder((Border)new SolidBorder(Color.GRAY, 0.01f))).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("Relationship manager:")));
            summaryTable.addCell(((Cell)((Cell)new Cell().setBorder((Border)new SolidBorder(Color.GRAY, 0.01f))).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph(portfolio.getRelationshipManager().getName())));
            summaryTable.addCell(((Cell)((Cell)new Cell().setBorder((Border)new SolidBorder(Color.GRAY, 0.01f))).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("Bank:")));
            summaryTable.addCell(((Cell)((Cell)new Cell().setBorder((Border)new SolidBorder(Color.GRAY, 0.01f))).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph(portfolio.getBank())));
            summaryTable.addCell(((Cell)((Cell)new Cell().setBorder((Border)new SolidBorder(Color.GRAY, 0.01f))).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("Month/Year:")));
            summaryTable.addCell(((Cell)((Cell)new Cell().setBorder((Border)new SolidBorder(Color.GRAY, 0.01f))).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph(String.valueOf(operationCalendar.get(2) + 1) + "/" + operationCalendar.get(1))));
            document.add((BlockElement)summaryTable);
            Table explanation = this.getSingleRowTextTable();
            explanation.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("If there is any YES to question 1 to 5, it means the operation is subject to AML.")));
            document.add((BlockElement)explanation);
            Table detailsRows = this.getAMLColsTable();
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).add((BlockElement)new Paragraph("YES")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).add((BlockElement)new Paragraph("NO")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("1. Credit or debit higher than CHF 100'000:")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).add((BlockElement)new Paragraph(operation.getAmlReason().equals("AML_ABOVE_100000") ? "X" : "")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).add((BlockElement)new Paragraph(operation.getAmlReason().equals("AML_ABOVE_100000") ? "" : "X")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("2. Credit or debit higher than 50% of the total AUM:")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).add((BlockElement)new Paragraph(operation.getAmlReason().equals("AML_ABOVE_50") ? "X" : "")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).add((BlockElement)new Paragraph(operation.getAmlReason().equals("AML_ABOVE_50") ? "" : "X")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("3. Cash credit or debit higher than CHF 25'000:")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).add((BlockElement)new Paragraph(operation.getAmlReason().equals("AML_CASH_ABOVE_25000") ? "X" : "")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).add((BlockElement)new Paragraph(operation.getAmlReason().equals("AML_CASH_ABOVE_25000") ? "" : "X")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("4. Pass-through transaction:")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).add((BlockElement)new Paragraph("")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).add((BlockElement)new Paragraph(operation.getAmlReason().equals("AML_NONE") ? "" : "X")));
            detailsRows.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBorderBottom((Border)new SolidBorder(Color.GRAY, 0.01f))).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("5. Unusual transaction:")));
            detailsRows.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBorderBottom((Border)new SolidBorder(Color.GRAY, 0.01f))).setTextAlignment(TextAlignment.CENTER)).add((BlockElement)new Paragraph("")));
            detailsRows.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBorderBottom((Border)new SolidBorder(Color.GRAY, 0.01f))).setTextAlignment(TextAlignment.CENTER)).add((BlockElement)new Paragraph(operation.getAmlReason().equals("AML_NONE") ? "" : "X")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("6. Associated documents:")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).add((BlockElement)new Paragraph(operation.getDocuments().length > 0 ? "X" : "")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).add((BlockElement)new Paragraph(operation.getDocuments().length > 0 ? "" : "X")));
            document.add((BlockElement)detailsRows);
            Table commentTable = this.getSingleRowTextTable();
            commentTable.addCell(((Cell)((Cell)new Cell().setBorder((Border)new SolidBorder(Color.GRAY, 0.01f))).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph(operation.getDescription().equals("") ? "N/A" : operation.getDescription())));
            document.add((BlockElement)commentTable);
            Table signatureRow = this.getDualSignaturesColsTable();
            signatureRow.addCell(((Cell)((Cell)new Cell(1, 2).setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("Date and relationship manager signature:")));
            signatureRow.addCell(((Cell)((Cell)new Cell(1, 2).setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("Date and compliance officer signature:")));
            signatureRow.addCell(((Cell)((Cell)((Cell)((Cell)new Cell().setHeight(30.0f)).setBorder(Border.NO_BORDER)).setBorderBottom((Border)new SolidBorder(Color.GRAY, 0.01f))).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph(" ")));
            signatureRow.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph(" ")));
            signatureRow.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBorderBottom((Border)new SolidBorder(Color.GRAY, 0.01f))).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph(" ")));
            signatureRow.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph(" ")));
            document.add((BlockElement)signatureRow);
            document.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return documentPath;
    }

    protected Table getTwoColsTable(float leftRatio) {
        Table table = new Table(new float[]{leftRatio, 1.0f - leftRatio});
        table.setBorder(Border.NO_BORDER);
        table.setFontSize(10.0f);
        table.setFontColor(Color.BLACK);
        table.setWidthPercent(100.0f);
        table.setMargin(15.0f);
        return table;
    }

    private Table getDualSignaturesColsTable() {
        Table table = new Table(new float[]{1.0f, 0.1f, 1.0f, 0.5f});
        table.setBorder(Border.NO_BORDER);
        table.setFontSize(10.0f);
        table.setFontColor(Color.BLACK);
        table.setWidthPercent(100.0f);
        table.setMargin(15.0f);
        return table;
    }

    private Table getAMLColsTable() {
        Table table = new Table(new float[]{1.0f, 0.5f, 0.5f});
        table.setBorder(Border.NO_BORDER);
        table.setFontSize(10.0f);
        table.setFontColor(Color.BLACK);
        table.setWidthPercent(100.0f);
        table.setMargin(15.0f);
        return table;
    }

    private Table getSingleRowTextTable() {
        Table table = new Table(new float[]{1.0f});
        table.setBorder(Border.NO_BORDER);
        table.setFontSize(10.0f);
        table.setFontColor(Color.BLACK);
        table.setWidthPercent(100.0f);
        table.setMargin(15.0f);
        return table;
    }
}

