/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report;

import com.fasterxml.jackson.databind.JsonNode;
import com.gso.finance.report.MainReport;
import com.gso.finance.report.block.BuySellOperationDetails;
import com.gso.finance.report.config.ReportsConfiguration;
import com.gso.finance.report.header.ContractNoteHeader;
import com.gso.finance.report.model.Operation;
import com.gso.finance.report.model.Portfolio;
import com.gso.finance.report.model.ReportInformation;
import com.gso.finance.util.rabbitmq.RabbitController;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.Table;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class OperationContractNote
implements MainReport {
    @Override
    public String generateReport(JsonNode data) {
        Portfolio portfolio = new Portfolio(data.get("portfolio"));
        Operation operation = new Operation(data.get("operation"));
        ReportInformation report = new ReportInformation(data.get("report"));
        String documentPath = "";
        try {
            ReportsConfiguration configuration = RabbitController.getInstance().getReportsConfiguration();
            documentPath = String.valueOf(configuration.getWorkingPath()) + "SECURITY_ORDER_" + operation.getId() + ".pdf";
            FileOutputStream fos = new FileOutputStream(documentPath);
            PdfWriter writer = new PdfWriter((OutputStream)fos);
            PdfFont defaultFont = PdfFontFactory.createFont((String)(String.valueOf(configuration.getResourcesPath()) + configuration.getDefaultFont()));
            PdfDocument pdf = new PdfDocument(writer);
            Document document = new Document(pdf, PageSize.A4);
            document.setFont(defaultFont);
            document.setMargins(15.0f, 15.0f, 15.0f, 15.0f);
            Table header = new ContractNoteHeader(configuration, report, portfolio, "SECURITY ORDER").getHeader();
            document.add((BlockElement)header);
            Table content = new BuySellOperationDetails(configuration, portfolio, operation).getDetailsTable();
            document.add((BlockElement)content);
            document.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return documentPath;
    }
}

