/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report;

import com.fasterxml.jackson.databind.JsonNode;
import com.gso.finance.report.MainReport;
import com.gso.finance.report.config.ReportsConfiguration;
import com.gso.finance.report.header.SimplePortfoliotHeader;
import com.gso.finance.report.model.Operation;
import com.gso.finance.report.model.Portfolio;
import com.gso.finance.report.model.ReportInformation;
import com.gso.finance.util.rabbitmq.RabbitController;
import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.layout.property.VerticalAlignment;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;

public class PortfolioOperationsClientBilling
implements MainReport {
    @Override
    public String generateReport(JsonNode data) {
        Portfolio portfolio = new Portfolio(data.get("portfolio"));
        Operation[] operations = Operation.fromJsonNode(data.get("operations"));
        ReportInformation report = new ReportInformation(data.get("report"));
        String documentPath = "";
        float total = 0.0f;
        Operation[] operationArray = operations;
        int n = operations.length;
        int n2 = 0;
        while (n2 < n) {
            Operation operation = operationArray[n2];
            total += operation.getBilling();
            ++n2;
        }
        try {
            ReportsConfiguration configuration = RabbitController.getInstance().getReportsConfiguration();
            documentPath = String.valueOf(configuration.getWorkingPath()) + "CLIENT_BILL_" + portfolio.getName() + ".pdf";
            FileOutputStream fos = new FileOutputStream(documentPath);
            PdfWriter writer = new PdfWriter((OutputStream)fos);
            PdfFont defaultFont = PdfFontFactory.createFont((String)(String.valueOf(configuration.getResourcesPath()) + configuration.getDefaultFont()));
            PdfDocument pdf = new PdfDocument(writer);
            Document document = new Document(pdf, PageSize.A4);
            document.setFont(defaultFont);
            document.setMargins(15.0f, 15.0f, 15.0f, 15.0f);
            Table header = new SimplePortfoliotHeader(configuration, report, portfolio, "CLIENT BILL").getHeader();
            document.add((BlockElement)header);
            Table positionDateHeader = this.getSingleRowTextTable();
            Date today = new Date();
            positionDateHeader.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.RIGHT)).add((BlockElement)new Paragraph(String.valueOf(portfolio.getManagementCompany().getCity()) + ", " + configuration.getDateTimePrettyFormatter().format(today))));
            document.add((BlockElement)positionDateHeader);
            Table billTitle = this.getSingleRowTextTable();
            Calendar billingCalendar = Calendar.getInstance();
            billingCalendar.setTime(report.getWorkingDate());
            StringBuffer billNumber = new StringBuffer();
            billNumber.append(billingCalendar.get(1));
            billNumber.append("-");
            billNumber.append((billingCalendar.get(2) + 1) / 4 + 1);
            billNumber.append("-");
            if (portfolio.getRelationshipManager() != null) {
                billNumber.append(portfolio.getRelationshipManager().getCode());
            } else {
                billNumber.append("N/A");
            }
            billNumber.append("-");
            billNumber.append(report.getDocumentNumber());
            billTitle.addCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setUnderline()).setBold()).add((BlockElement)new Paragraph("TRANSACTIONS BILL #" + billNumber.toString())));
            document.add((BlockElement)billTitle);
            Table custodianRow = this.getTwoColsTable(0.4f);
            custodianRow.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("Custodian:")));
            custodianRow.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph(portfolio.getBank())));
            custodianRow.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("Billing period:")));
            custodianRow.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph(String.valueOf(configuration.getDateFormatter().format(report.getStartDate())) + " to " + configuration.getDateFormatter().format(report.getWorkingDate()))));
            document.add((BlockElement)custodianRow);
            Table detailsRows = this.getFourColsTable();
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("Fees")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph(String.valueOf(portfolio.getManagementCompany().getCurrencyCode()) + " " + configuration.getPriceFormatter().format(total))));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("VAT (" + configuration.getPercentFormatter().format(portfolio.getVatRate()) + ")")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph(String.valueOf(portfolio.getManagementCompany().getCurrencyCode()) + " " + configuration.getPriceFormatter().format(total * portfolio.getVatRate()))));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("")));
            detailsRows.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).setBold()).add((BlockElement)new Paragraph("Total")));
            detailsRows.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).add((BlockElement)new Paragraph("")));
            detailsRows.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).setBold()).add((BlockElement)new Paragraph(String.valueOf(portfolio.getManagementCompany().getCurrencyCode()) + " " + configuration.getPriceFormatter().format(total * (1.0f + portfolio.getVatRate())))));
            document.add((BlockElement)detailsRows);
            Table addressRow = this.getTwoColsTable(0.1f);
            addressRow.setWidthPercent(80.0f);
            addressRow.addCell((Cell)((Cell)((Cell)((Cell)new Cell(1, 2).setBorder(Border.NO_BORDER)).setFontColor(configuration.getSequoiaGreen())).setFontSize(7.0f)).add((BlockElement)new Paragraph(portfolio.getManagementCompany().getSignatureAddress())).setRotationAngle(1.5708f));
            addressRow.setMarginLeft(-10.0f);
            Table signatureRow = this.getTwoColsTable(0.5f);
            signatureRow.addCell(((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, 2).setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).setBold()).setVerticalAlignment(VerticalAlignment.MIDDLE)).setTextAlignment(TextAlignment.CENTER)).add((BlockElement)new Paragraph("Relationship manager signature:")));
            signatureRow.setMarginTop(-250.0f);
            signatureRow.setMarginLeft(-100.0f);
            document.add((BlockElement)addressRow);
            document.add((BlockElement)signatureRow);
            document.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return documentPath;
    }

    private Table getTwoColsTable(float leftRatio) {
        Table table = new Table(new float[]{leftRatio, 1.0f - leftRatio});
        table.setBorder(Border.NO_BORDER);
        table.setFontSize(10.0f);
        table.setFontColor(Color.BLACK);
        table.setWidthPercent(100.0f);
        table.setMargin(15.0f);
        return table;
    }

    private Table getFourColsTable() {
        Table table = new Table(new float[]{1.0f, 1.0f, 1.0f, 1.0f});
        table.setBorder(Border.NO_BORDER);
        table.setFontSize(10.0f);
        table.setFontColor(Color.BLACK);
        table.setWidthPercent(100.0f);
        table.setMargin(15.0f);
        return table;
    }

    private Table getSingleRowTextTable() {
        Table table = new Table(new float[]{1.0f});
        table.setBorder(Border.NO_BORDER);
        table.setFontSize(10.0f);
        table.setFontColor(Color.BLACK);
        table.setWidthPercent(100.0f);
        table.setMargin(15.0f);
        return table;
    }
}

