/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report.block;

import com.gso.finance.report.config.ReportsConfiguration;
import com.gso.finance.report.model.Account;
import com.gso.finance.report.model.Portfolio;
import com.itextpdf.kernel.color.Color;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.border.SolidBorder;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.TextAlignment;
import java.util.ArrayList;

public class CashAccountsDetails {
    private ReportsConfiguration configuration;
    private Portfolio portfolio;
    private String title;
    private Table detailsTable = null;
    private boolean withSpot = false;

    public CashAccountsDetails(ReportsConfiguration configuration, Portfolio portfolio, String title, boolean withSpot) {
        this.configuration = configuration;
        this.portfolio = portfolio;
        this.title = title;
        this.withSpot = withSpot;
    }

    public void createAccountDetailsHeader(boolean aggregated) {
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Number")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Name")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Currency")));
        if (aggregated) {
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Bank")));
        }
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Initial amount")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Movements")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("PnL")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Buy/Sell")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Final amount")));
        if (this.withSpot) {
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Spot rate")));
        }
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Final amount (" + this.portfolio.getCurrency() + ")")));
    }

    public void createAccountDetailsData(Account account, boolean aggregated, boolean subAccount) {
        if (aggregated) {
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell(1, 2).setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).setBold()).add((BlockElement)new Paragraph("Consolidated " + account.getCurrency() + " account")));
        } else if (subAccount) {
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setItalic()).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(account.getCode())));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setItalic()).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(account.getName())));
        } else {
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(account.getCode())));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(account.getName())));
        }
        if (subAccount) {
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setItalic()).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(account.getCurrency())));
        } else if (aggregated) {
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).setBold()).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(account.getCurrency())));
        } else {
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(account.getCurrency())));
        }
        if (aggregated) {
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).setBold()).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph("-")));
        }
        if (subAccount) {
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setItalic()).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(account.getBank())));
        }
        if (subAccount) {
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setItalic()).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(account.getBeginningAssets().localCurrency))));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setItalic()).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(account.getMovementsDetails().getCashMovement()))));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setItalic()).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(account.getMovementsDetails().getImpactingMovement()))));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setItalic()).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(account.getMovementsDetails().getBuySellDifference()))));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setItalic()).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(account.getEndAssets().localCurrency))));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setItalic()).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(account.getEndAssets().portfolioCurrency))));
        } else if (aggregated) {
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setBold()).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(account.getBeginningAssets().localCurrency))));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setBold()).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(account.getMovementsDetails().getCashMovement()))));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setBold()).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(account.getMovementsDetails().getImpactingMovement()))));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setBold()).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(account.getMovementsDetails().getBuySellDifference()))));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setBold()).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(account.getEndAssets().localCurrency))));
            if (this.withSpot) {
                if (account.getEndAssets().portfolioCurrency != account.getEndAssets().localCurrency || account.getEndAssets().localCurrency == 0.0f) {
                    this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getSpotFormatter().format(account.getEndAssets().portfolioCurrency / account.getEndAssets().localCurrency))));
                } else {
                    this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph("N/A")));
                }
            }
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setBold()).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(account.getEndAssets().portfolioCurrency))));
        } else {
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(account.getBeginningAssets().localCurrency))));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(account.getMovementsDetails().getCashMovement()))));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(account.getMovementsDetails().getImpactingMovement()))));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(account.getMovementsDetails().getBuySellDifference()))));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(account.getEndAssets().localCurrency))));
            if (this.withSpot) {
                if (account.getEndAssets().portfolioCurrency != account.getEndAssets().localCurrency || account.getEndAssets().localCurrency == 0.0f) {
                    this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getSpotFormatter().format(account.getEndAssets().portfolioCurrency / account.getEndAssets().localCurrency))));
                } else {
                    this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph("N/A")));
                }
            }
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(account.getEndAssets().portfolioCurrency))));
        }
    }

    public Table getDetailsTable(boolean aggregated) {
        if (this.detailsTable == null) {
            Account wrkAccount;
            int n;
            int n2;
            Account[] accountArray;
            Portfolio subPortfolio;
            int n3;
            int n4;
            Portfolio[] portfolioArray;
            Account account;
            int n5;
            int n6;
            Account[] accountArray2;
            int colSpan;
            this.detailsTable = aggregated ? (this.withSpot ? new Table(new float[]{2.5f, 3.0f, 1.0f, 1.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f}) : new Table(new float[]{2.5f, 3.0f, 1.0f, 1.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f})) : (this.withSpot ? new Table(new float[]{2.5f, 4.0f, 1.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f}) : new Table(new float[]{2.5f, 4.0f, 1.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f}));
            int n7 = colSpan = this.portfolio.getSubPortfolios().length > 0 ? 10 : 9;
            if (this.withSpot) {
                ++colSpan;
            }
            this.detailsTable.setWidthPercent(100.0f);
            this.detailsTable.setTextAlignment(TextAlignment.CENTER);
            this.detailsTable.setFontSize(6.0f);
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, colSpan).setBorder(Border.NO_BORDER)).setBold()).setFontSize(8.0f)).setBackgroundColor(this.configuration.getSequoiaGreen())).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph(this.title)));
            ArrayList<String> accountTypes = new ArrayList<String>();
            Account[] accountArray3 = this.portfolio.getAccounts();
            int n8 = accountArray3.length;
            int n9 = 0;
            while (n9 < n8) {
                Account account2 = accountArray3[n9];
                if (accountTypes.indexOf(account2.getType()) == -1) {
                    accountTypes.add(account2.getType());
                }
                ++n9;
            }
            SolidBorder bigBorder = new SolidBorder(this.configuration.getSequoiaGreen(), 0.02f);
            float globalTotal = 0.0f;
            if (accountTypes.indexOf("Current account") >= 0) {
                this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell(1, colSpan).setBorder(Border.NO_BORDER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("")));
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, colSpan).setBorder(Border.NO_BORDER)).setBold()).setFontSize(7.0f)).setBackgroundColor(this.configuration.getPdfColors()[2])).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Current accounts")));
                this.createAccountDetailsHeader(this.portfolio.getSubPortfolios().length > 0);
                float total = 0.0f;
                accountArray2 = this.portfolio.getAccounts();
                n6 = accountArray2.length;
                n5 = 0;
                while (n5 < n6) {
                    account = accountArray2[n5];
                    if (account.getType().equals("Current account")) {
                        this.createAccountDetailsData(account, this.portfolio.getSubPortfolios().length > 0, false);
                        portfolioArray = this.portfolio.getSubPortfolios();
                        n4 = portfolioArray.length;
                        n3 = 0;
                        while (n3 < n4) {
                            subPortfolio = portfolioArray[n3];
                            accountArray = subPortfolio.getAccounts();
                            n2 = accountArray.length;
                            n = 0;
                            while (n < n2) {
                                wrkAccount = accountArray[n];
                                if (wrkAccount.getCurrency().equals(account.getCurrency()) && wrkAccount.getType().equals(account.getType())) {
                                    this.createAccountDetailsData(wrkAccount, false, true);
                                }
                                ++n;
                            }
                            ++n3;
                        }
                        total += account.getEndAssets().portfolioCurrency;
                    }
                    ++n5;
                }
                if (accountTypes.size() > 1) {
                    this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, colSpan).setBorder(Border.NO_BORDER)).setBorderBottom((Border)bigBorder)).setBorderTop((Border)bigBorder)).setBold()).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.RIGHT)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph("Total (" + this.portfolio.getCurrency() + "): " + this.configuration.getAmountFormatter().format(total))));
                }
                globalTotal += total;
            }
            if (accountTypes.indexOf("Loan account") >= 0) {
                this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell(1, colSpan).setBorder(Border.NO_BORDER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("")));
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, colSpan).setBorder(Border.NO_BORDER)).setBold()).setFontSize(7.0f)).setBackgroundColor(this.configuration.getPdfColors()[2])).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Loan accounts")));
                this.createAccountDetailsHeader(this.portfolio.getSubPortfolios().length > 0);
                float total = 0.0f;
                accountArray2 = this.portfolio.getAccounts();
                n6 = accountArray2.length;
                n5 = 0;
                while (n5 < n6) {
                    account = accountArray2[n5];
                    if (account.getType().equals("Loan account")) {
                        this.createAccountDetailsData(account, this.portfolio.getSubPortfolios().length > 0, false);
                        portfolioArray = this.portfolio.getSubPortfolios();
                        n4 = portfolioArray.length;
                        n3 = 0;
                        while (n3 < n4) {
                            subPortfolio = portfolioArray[n3];
                            accountArray = subPortfolio.getAccounts();
                            n2 = accountArray.length;
                            n = 0;
                            while (n < n2) {
                                wrkAccount = accountArray[n];
                                if (wrkAccount.getCurrency().equals(account.getCurrency()) && wrkAccount.getType().equals(account.getType())) {
                                    this.createAccountDetailsData(wrkAccount, false, true);
                                }
                                ++n;
                            }
                            ++n3;
                        }
                        total += account.getEndAssets().portfolioCurrency;
                    }
                    ++n5;
                }
                if (accountTypes.size() > 1) {
                    this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, colSpan).setBorder(Border.NO_BORDER)).setBorderBottom((Border)bigBorder)).setBorderTop((Border)bigBorder)).setBorderBottom((Border)bigBorder)).setBorderTop((Border)bigBorder)).setBold()).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.RIGHT)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph("Total (" + this.portfolio.getCurrency() + "): " + this.configuration.getAmountFormatter().format(total))));
                }
                globalTotal += total;
            }
            if (accountTypes.indexOf("Forward account") >= 0) {
                this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell(1, colSpan).setBorder(Border.NO_BORDER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("")));
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, colSpan).setBorder(Border.NO_BORDER)).setBold()).setFontSize(7.0f)).setBackgroundColor(this.configuration.getPdfColors()[2])).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Forward accounts")));
                this.createAccountDetailsHeader(this.portfolio.getSubPortfolios().length > 0);
                float total = 0.0f;
                accountArray2 = this.portfolio.getAccounts();
                n6 = accountArray2.length;
                n5 = 0;
                while (n5 < n6) {
                    account = accountArray2[n5];
                    if (account.getType().equals("Forward account")) {
                        this.createAccountDetailsData(account, this.portfolio.getSubPortfolios().length > 0, false);
                        portfolioArray = this.portfolio.getSubPortfolios();
                        n4 = portfolioArray.length;
                        n3 = 0;
                        while (n3 < n4) {
                            subPortfolio = portfolioArray[n3];
                            accountArray = subPortfolio.getAccounts();
                            n2 = accountArray.length;
                            n = 0;
                            while (n < n2) {
                                wrkAccount = accountArray[n];
                                if (wrkAccount.getCurrency().equals(account.getCurrency()) && wrkAccount.getType().equals(account.getType())) {
                                    this.createAccountDetailsData(wrkAccount, false, true);
                                }
                                ++n;
                            }
                            ++n3;
                        }
                        total += account.getEndAssets().portfolioCurrency;
                    }
                    ++n5;
                }
                if (accountTypes.size() > 1) {
                    this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, colSpan).setBorder(Border.NO_BORDER)).setBorderBottom((Border)bigBorder)).setBorderTop((Border)bigBorder)).setBold()).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.RIGHT)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph("Total (" + this.portfolio.getCurrency() + "): " + this.configuration.getAmountFormatter().format(total))));
                }
                globalTotal += total;
            }
            if (accountTypes.indexOf("Guarantee account") >= 0) {
                this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell(1, colSpan).setBorder(Border.NO_BORDER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("")));
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, colSpan).setBorder(Border.NO_BORDER)).setBold()).setFontSize(7.0f)).setBackgroundColor(this.configuration.getPdfColors()[2])).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Guarantee accounts")));
                this.createAccountDetailsHeader(this.portfolio.getSubPortfolios().length > 0);
                float total = 0.0f;
                accountArray2 = this.portfolio.getAccounts();
                n6 = accountArray2.length;
                n5 = 0;
                while (n5 < n6) {
                    account = accountArray2[n5];
                    if (account.getType().equals("Guarantee account")) {
                        this.createAccountDetailsData(account, this.portfolio.getSubPortfolios().length > 0, false);
                        portfolioArray = this.portfolio.getSubPortfolios();
                        n4 = portfolioArray.length;
                        n3 = 0;
                        while (n3 < n4) {
                            subPortfolio = portfolioArray[n3];
                            accountArray = subPortfolio.getAccounts();
                            n2 = accountArray.length;
                            n = 0;
                            while (n < n2) {
                                wrkAccount = accountArray[n];
                                if (wrkAccount.getCurrency().equals(account.getCurrency()) && wrkAccount.getType().equals(account.getType())) {
                                    this.createAccountDetailsData(wrkAccount, false, true);
                                }
                                ++n;
                            }
                            ++n3;
                        }
                        total += account.getEndAssets().portfolioCurrency;
                    }
                    ++n5;
                }
                if (accountTypes.size() > 1) {
                    this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, colSpan).setBorder(Border.NO_BORDER)).setBorderBottom((Border)bigBorder)).setBorderTop((Border)bigBorder)).setBold()).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.RIGHT)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph("Total (" + this.portfolio.getCurrency() + "): " + this.configuration.getAmountFormatter().format(total))));
                }
                globalTotal += total;
            }
            this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell(1, colSpan).setBorder(Border.NO_BORDER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("")));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, colSpan).setBorder(Border.NO_BORDER)).setBold()).setFontSize(8.0f)).setBackgroundColor(this.configuration.getSequoiaGreen())).setTextAlignment(TextAlignment.RIGHT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Grand total (" + this.portfolio.getCurrency() + "): " + this.configuration.getAmountFormatter().format(globalTotal))));
        }
        return this.detailsTable;
    }

    public void setDetailsTable(Table detailsTable) {
        this.detailsTable = detailsTable;
    }
}

