/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report.block;

import com.gso.finance.report.config.ReportsConfiguration;
import com.gso.finance.report.model.ConstraintResult;
import com.gso.finance.report.model.Portfolio;
import com.itextpdf.kernel.color.Color;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.TextAlignment;
import java.util.ArrayList;

public class ConstraintsDetails {
    private ReportsConfiguration configuration;
    private Portfolio portfolio;
    private ArrayList<ConstraintResult> constraints = new ArrayList();
    private Table detailsTable = null;

    public ConstraintsDetails(ReportsConfiguration configuration, Portfolio portfolio, ArrayList<ConstraintResult> constraints) {
        this.configuration = configuration;
        this.portfolio = portfolio;
        this.constraints = constraints;
    }

    public void createConstraintsDetailsHeader() {
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Constraint")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph(" ")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Minimum range")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Maximum range")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Current value")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Status")));
    }

    public void createConstraintsDetailsData() {
        for (ConstraintResult cr : this.constraints) {
            Color rowColor = cr.isConstraintBroken() ? this.configuration.getSequoiaRed() : this.configuration.getSequoiaGreen();
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).setFontColor(rowColor)).add((BlockElement)new Paragraph(cr.getName())));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).setFontColor(rowColor)).add((BlockElement)new Paragraph(cr.getMessage())));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(rowColor)).add((BlockElement)new Paragraph(this.configuration.getPercentFormatter().format(cr.getMinimum()))));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(rowColor)).add((BlockElement)new Paragraph(this.configuration.getPercentFormatter().format(cr.getMaximum()))));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(rowColor)).add((BlockElement)new Paragraph(this.configuration.getPercentFormatter().format(cr.getValue()))));
            if (cr.isConstraintBroken()) {
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setBold()).setFontColor(rowColor)).add((BlockElement)new Paragraph("BROKEN")));
                continue;
            }
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setBold()).setFontColor(rowColor)).add((BlockElement)new Paragraph("OK")));
        }
    }

    public Table getDetailsTable() {
        if (this.detailsTable == null) {
            String title = String.valueOf(this.portfolio.getName()) + " - " + this.portfolio.getMandate() + "/" + this.portfolio.getStyle();
            this.detailsTable = new Table(new float[]{4.0f, 6.0f, 2.0f, 2.0f, 2.0f, 2.0f});
            this.detailsTable.setWidthPercent(100.0f);
            this.detailsTable.setTextAlignment(TextAlignment.CENTER);
            this.detailsTable.setFontSize(6.0f);
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, 6).setBorder(Border.NO_BORDER)).setBold()).setFontSize(8.0f)).setBackgroundColor(this.configuration.getSequoiaGreen())).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph(title)));
            this.createConstraintsDetailsHeader();
            this.createConstraintsDetailsData();
        }
        return this.detailsTable;
    }

    public void setDetailsTable(Table detailsTable) {
        this.detailsTable = detailsTable;
    }
}

