/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report.block;

import com.gso.finance.report.config.ReportsConfiguration;
import com.gso.finance.report.model.Portfolio;
import com.gso.finance.report.model.ReportInformation;
import com.itextpdf.kernel.color.Color;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.TextAlignment;

public class DefaultAssetsDetails {
    private ReportsConfiguration configuration;
    private Portfolio portfolio;
    private String title;
    private ReportInformation report;
    private Table detailsTable = null;

    public DefaultAssetsDetails(ReportsConfiguration configuration, ReportInformation report, Portfolio portfolio, String title) {
        this.configuration = configuration;
        this.portfolio = portfolio;
        this.title = title;
        this.report = report;
    }

    public Table getDetailsTable() {
        if (this.detailsTable == null) {
            this.detailsTable = new Table(new float[]{5.0f, 5.0f});
            this.detailsTable.setBorder(Border.NO_BORDER);
            this.detailsTable.setWidthPercent(100.0f);
            Paragraph invisibleCell = new Paragraph("N/A");
            invisibleCell.setFontSize(4.0f);
            invisibleCell.setFontColor(Color.WHITE);
            Paragraph titleElement = new Paragraph(this.title);
            titleElement.setFontColor(this.configuration.getSequoiaGreen());
            titleElement.setFontSize(6.0f);
            titleElement.setBold();
            Paragraph valueElement = new Paragraph(String.valueOf(this.configuration.getAmountFormatter().format(this.portfolio.getEndAUM())) + " " + this.portfolio.getCurrency());
            valueElement.setFontColor(this.configuration.getSequoiaGreen());
            valueElement.setFontSize(6.0f);
            valueElement.setBold();
            this.detailsTable.addHeaderCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)titleElement).setTextAlignment(TextAlignment.LEFT));
            this.detailsTable.addHeaderCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)valueElement).setTextAlignment(TextAlignment.RIGHT));
            titleElement = new Paragraph("Period:");
            titleElement.setFontSize(6.0f);
            valueElement = new Paragraph(String.valueOf(this.configuration.getDateFormatter().format(this.report.getStartDate())) + " - " + this.configuration.getDateFormatter().format(this.report.getWorkingDate()));
            valueElement.setFontSize(6.0f);
            this.detailsTable.addHeaderCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)titleElement).setTextAlignment(TextAlignment.LEFT));
            this.detailsTable.addHeaderCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)valueElement).setTextAlignment(TextAlignment.RIGHT));
            this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)invisibleCell));
            this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)invisibleCell));
            titleElement = new Paragraph("Initial Asset:");
            titleElement.setFontSize(6.0f);
            valueElement = new Paragraph(String.valueOf(this.configuration.getAmountFormatter().format(this.portfolio.getStartAUM())) + " " + this.portfolio.getCurrency());
            valueElement.setFontSize(6.0f);
            this.detailsTable.addHeaderCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)titleElement).setTextAlignment(TextAlignment.LEFT));
            this.detailsTable.addHeaderCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)valueElement).setTextAlignment(TextAlignment.RIGHT));
            titleElement = new Paragraph("Deposits/Withdrawals:");
            titleElement.setFontSize(6.0f);
            valueElement = new Paragraph(String.valueOf(this.configuration.getAmountFormatter().format(this.portfolio.getMovements())) + " " + this.portfolio.getCurrency());
            valueElement.setFontSize(6.0f);
            this.detailsTable.addHeaderCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)titleElement).setTextAlignment(TextAlignment.LEFT));
            this.detailsTable.addHeaderCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)valueElement).setTextAlignment(TextAlignment.RIGHT));
            titleElement = new Paragraph("Average Invested Capital:");
            titleElement.setFontSize(6.0f);
            valueElement = new Paragraph(String.valueOf(this.configuration.getAmountFormatter().format(this.portfolio.getAverageInvestedAUM())) + " " + this.portfolio.getCurrency());
            valueElement.setFontSize(6.0f);
            this.detailsTable.addHeaderCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)titleElement).setTextAlignment(TextAlignment.LEFT));
            this.detailsTable.addHeaderCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)valueElement).setTextAlignment(TextAlignment.RIGHT));
            titleElement = new Paragraph("Profit/Loss:");
            titleElement.setFontSize(6.0f);
            valueElement = new Paragraph(String.valueOf(this.configuration.getAmountFormatter().format(this.portfolio.getPnl() + this.portfolio.getFxPnl())) + " " + this.portfolio.getCurrency());
            valueElement.setFontSize(6.0f);
            this.detailsTable.addHeaderCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)titleElement).setTextAlignment(TextAlignment.LEFT));
            this.detailsTable.addHeaderCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)valueElement).setTextAlignment(TextAlignment.RIGHT));
            this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)invisibleCell));
            this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)invisibleCell));
            this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)invisibleCell));
            this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)invisibleCell));
            titleElement = new Paragraph("Performance:");
            titleElement.setFontSize(6.0f);
            valueElement = new Paragraph(this.configuration.getPercentFormatter().format(this.portfolio.getPerformance()));
            if (this.portfolio.getPerformance() >= 0.0f) {
                valueElement.setFontColor(this.configuration.getSequoiaGreen());
            } else {
                valueElement.setFontColor(this.configuration.getSequoiaRed());
            }
            valueElement.setFontSize(7.0f);
            valueElement.setBold();
            this.detailsTable.addHeaderCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)titleElement).setTextAlignment(TextAlignment.LEFT));
            this.detailsTable.addHeaderCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)valueElement).setTextAlignment(TextAlignment.RIGHT));
            this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)invisibleCell));
            this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)invisibleCell));
            titleElement = new Paragraph("Inception date:");
            titleElement.setFontSize(6.0f);
            valueElement = new Paragraph(this.configuration.getDateFormatter().format(this.portfolio.getInceptionDate()));
            valueElement.setFontSize(6.0f);
            this.detailsTable.addHeaderCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)titleElement).setTextAlignment(TextAlignment.LEFT));
            this.detailsTable.addHeaderCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)valueElement).setTextAlignment(TextAlignment.RIGHT));
        }
        return this.detailsTable;
    }
}

