/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report.block;

import com.gso.finance.report.config.ReportsConfiguration;
import com.gso.finance.report.model.Breakdown;
import com.gso.finance.report.model.Portfolio;
import com.gso.finance.report.renderer.DefaultBarRenderer;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.TextAlignment;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleInsets;

public class HorizontalBarChartBreakdown {
    private Breakdown[] breakdowns;
    private ReportsConfiguration configuration;
    private Portfolio portfolio;
    private String title;
    private Table breakdownsTable = null;
    private int tableHeights;

    public HorizontalBarChartBreakdown(ReportsConfiguration configuration, Portfolio portfolio, Breakdown[] breakdowns, String title, int tableHeights) {
        Arrays.sort(breakdowns);
        this.configuration = configuration;
        this.portfolio = portfolio;
        this.breakdowns = breakdowns;
        this.title = title;
        this.tableHeights = tableHeights;
    }

    /*
     * Unable to fully structure code
     */
    public Table getBreakdownsTable() {
        block7: {
            block8: {
                if (this.breakdownsTable != null) break block7;
                this.breakdownsTable = new Table(new float[]{4.0f, 3.0f, 3.0f});
                this.breakdownsTable.setBorder(Border.NO_BORDER);
                this.breakdownsTable.setWidthPercent(100.0f);
                invisibleCell = new Paragraph("N/A");
                invisibleCell.setFontSize(6.0f);
                invisibleCell.setFontColor(com.itextpdf.kernel.color.Color.WHITE);
                titleElement = new Paragraph(this.title);
                titleElement.setFontColor(this.configuration.getSequoiaGreen());
                titleElement.setFontSize(6.0f);
                titleElement.setBold();
                currencyElement = new Paragraph(this.portfolio.getCurrency());
                currencyElement.setFontColor(this.configuration.getSequoiaGreen());
                currencyElement.setFontSize(6.0f);
                currencyElement.setBold();
                weightTitleElement = new Paragraph("Weight");
                weightTitleElement.setFontColor(this.configuration.getSequoiaGreen());
                weightTitleElement.setFontSize(6.0f);
                weightTitleElement.setBold();
                this.breakdownsTable.addHeaderCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)titleElement).setTextAlignment(TextAlignment.LEFT));
                this.breakdownsTable.addHeaderCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)currencyElement).setTextAlignment(TextAlignment.CENTER));
                this.breakdownsTable.addHeaderCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)weightTitleElement).setTextAlignment(TextAlignment.CENTER));
                index = 0;
                otherNameElement = null;
                otherValue = 0.0f;
                otherWeight = 0.0f;
                totalValue = 0.0f;
                totalWeight = 0.0f;
                chartData = new DefaultCategoryDataset();
                var15_12 = this.breakdowns;
                var14_13 = this.breakdowns.length;
                var13_15 = 0;
                while (var13_15 < var14_13) {
                    bd = var15_12[var13_15];
                    nameElement = new Paragraph(bd.name);
                    nameElement.setFontSize(6.0f);
                    if (index >= this.tableHeights - 1) {
                        if (otherNameElement == null) {
                            otherNameElement = new Paragraph("OTHER");
                            otherNameElement.setFontSize(6.0f);
                        }
                        otherValue += bd.value;
                        otherWeight += bd.weight;
                    } else {
                        valueElement = new Paragraph(this.configuration.getAmountFormatter().format(bd.value));
                        valueElement.setFontSize(6.0f);
                        weightElement = new Paragraph(this.configuration.getPercentFormatter().format(bd.weight));
                        weightElement.setFontSize(6.0f);
                        this.breakdownsTable.addCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)nameElement).setTextAlignment(TextAlignment.LEFT));
                        this.breakdownsTable.addCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)valueElement).setTextAlignment(TextAlignment.CENTER));
                        this.breakdownsTable.addCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)weightElement).setTextAlignment(TextAlignment.CENTER));
                        chartData.addValue((double)(bd.weight * 100.0f), (Comparable)"Weight", (Comparable)bd.name);
                    }
                    totalValue += bd.value;
                    totalWeight += bd.weight;
                    ++index;
                    ++var13_15;
                }
                if (otherNameElement == null) ** GOTO lbl103
                this.breakdownsTable.addCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add(otherNameElement).setTextAlignment(TextAlignment.LEFT));
                valueElement = new Paragraph(this.configuration.getAmountFormatter().format(otherValue));
                valueElement.setFontSize(6.0f);
                weightElement = new Paragraph(this.configuration.getPercentFormatter().format(otherWeight));
                weightElement.setFontSize(6.0f);
                this.breakdownsTable.addCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)valueElement).setTextAlignment(TextAlignment.CENTER));
                this.breakdownsTable.addCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)weightElement).setTextAlignment(TextAlignment.CENTER));
                chartData.addValue((double)(otherWeight * 100.0f), (Comparable)"Weight", (Comparable)"OTHER");
                break block8;
lbl-1000:
                // 1 sources

                {
                    this.breakdownsTable.addCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)invisibleCell));
                    this.breakdownsTable.addCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)invisibleCell));
                    this.breakdownsTable.addCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)invisibleCell));
                    chartData.addValue(0.0, (Comparable)"Weight", (Comparable)"");
                    ++index;
lbl103:
                    // 2 sources

                    ** while (index < this.tableHeights)
                }
            }
            nameElement = new Paragraph("Total Asset Value");
            nameElement.setFontSize(6.0f);
            nameElement.setBold();
            this.breakdownsTable.addCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)nameElement).setTextAlignment(TextAlignment.LEFT));
            valueElement = new Paragraph(this.configuration.getAmountFormatter().format(totalValue));
            valueElement.setFontSize(6.0f);
            valueElement.setBold();
            weightElement = new Paragraph(this.configuration.getPercentFormatter().format(totalWeight));
            weightElement.setFontSize(6.0f);
            weightElement.setBold();
            this.breakdownsTable.addCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)valueElement).setTextAlignment(TextAlignment.CENTER));
            this.breakdownsTable.addCell((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)weightElement).setTextAlignment(TextAlignment.CENTER));
            chart = ChartFactory.createBarChart(null, null, null, (CategoryDataset)chartData, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
            chart.setBorderVisible(false);
            chart.setPadding(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
            plot = (CategoryPlot)chart.getPlot();
            plot.setBackgroundPaint((Paint)Color.WHITE);
            plot.setOutlineVisible(false);
            renderer = new DefaultBarRenderer(this.configuration);
            renderer.setBarPainter((BarPainter)new StandardBarPainter());
            renderer.setShadowXOffset(0.0);
            renderer.setShadowYOffset(0.0);
            plot.setRenderer((CategoryItemRenderer)renderer);
            try {
                pieFile = File.createTempFile(String.valueOf(this.portfolio.getName()) + "_", "_" + this.title + ".png", new File(this.configuration.getWorkingPath()));
                ChartUtilities.saveChartAsPNG((File)pieFile, (JFreeChart)chart, (int)600, (int)180);
                chartImage = new Image(ImageDataFactory.create((String)pieFile.getCanonicalPath()));
                chartImage.scale(0.49f, 0.49f);
                this.breakdownsTable.addFooterCell(((Cell)new Cell(1, 3).setBorder(Border.NO_BORDER)).add(chartImage));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.breakdownsTable;
    }

    public Breakdown[] getBreakdowns() {
        return this.breakdowns;
    }

    public void setBreakdowns(Breakdown[] breakdowns) {
        this.breakdowns = breakdowns;
    }

    public ReportsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ReportsConfiguration configuration) {
        this.configuration = configuration;
    }

    public Portfolio getPortfolio() {
        return this.portfolio;
    }

    public void setPortfolio(Portfolio portfolio) {
        this.portfolio = portfolio;
    }
}

