/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report.block;

import com.gso.finance.report.config.ReportsConfiguration;
import com.gso.finance.report.model.Account;
import com.gso.finance.report.model.Operation;
import com.itextpdf.kernel.color.Color;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.TextAlignment;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class MovementsDetails
implements Serializable {
    private static final long serialVersionUID = 8741055555747154923L;
    private static Logger LOGGER = Logger.getLogger(MovementsDetails.class);
    private ReportsConfiguration configuration;
    private Operation[] operations;
    private String title;
    private Account filteringAccount;
    private ArrayList<Table> detailsTables = null;
    private Table detailsTable = null;

    public MovementsDetails(ReportsConfiguration configuration, Operation[] operations, String title, Account filteringAccount) {
        this.configuration = configuration;
        this.operations = operations;
        this.title = title;
        this.filteringAccount = filteringAccount;
    }

    private void createMovementDetailsHeader() {
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Operation")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Value date")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Currency")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Debit")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Credit")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.RIGHT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Balance")));
    }

    public ArrayList<Table> getDetailsTables() {
        float previousBalance = this.filteringAccount.getBeginningAssets().localCurrency;
        if (this.detailsTables == null) {
            this.detailsTables = new ArrayList();
            this.detailsTable = new Table(new float[]{8.0f, 2.0f, 2.0f, 2.0f, 2.0f, 3.0f});
            this.detailsTables.add(this.detailsTable);
            this.detailsTable.setWidthPercent(100.0f);
            this.detailsTable.setTextAlignment(TextAlignment.CENTER);
            this.detailsTable.setFontSize(6.0f);
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, 6).setBorder(Border.NO_BORDER)).setBold()).setFontSize(8.0f)).setBackgroundColor(this.configuration.getSequoiaGreen())).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph(this.title)));
            this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell(1, 6).setBorder(Border.NO_BORDER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("")));
            this.createMovementDetailsHeader();
            this.detailsTable.addCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, 5).setBorder(Border.NO_BORDER)).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.RIGHT)).setFontColor(this.configuration.getSequoiaGreen())).setBold()).add((BlockElement)new Paragraph("Begin of period balance")));
            this.detailsTable.addCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.RIGHT)).setFontColor(this.filteringAccount.getBeginningAssets().localCurrency >= 0.0f ? this.configuration.getSequoiaGreen() : this.configuration.getSequoiaRed())).setBold()).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(this.filteringAccount.getBeginningAssets().localCurrency))));
            Operation[] operationArray = this.operations;
            int n = this.operations.length;
            int n2 = 0;
            while (n2 < n) {
                Operation operation = operationArray[n2];
                if (operation.getSourceAccount() != null && operation.getSourceAccount().getCode().equals(this.filteringAccount.getCode()) || operation.getTargetAccount() != null && operation.getTargetAccount().getCode().equals(this.filteringAccount.getCode())) {
                    this.detailsTable.addCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBold()).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.LEFT)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(operation.getName())));
                    this.detailsTable.addCell(((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.LEFT)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.configuration.getDateFormatter().format(operation.getValueDate()))));
                    float amount = operation.getAmount();
                    if (operation.getTargetAccount() == null || operation.getTargetAccount().getType().indexOf("Security") >= 0 || operation.getTargetAccount() != null && operation.getTargetAccount().getCode().equals(this.filteringAccount.getCode())) {
                        amount = operation.getAmount() * (operation.getSpotRate() == 0.0f ? 1.0f : operation.getSpotRate());
                    }
                    if (operation.getTargetAccount() != null && operation.getTargetAccount().getType().indexOf("Security") < 0 && operation.getSourceAccount() != null && operation.getSourceAccount().getCode().equals(this.filteringAccount.getCode())) {
                        amount *= -1.0f;
                    }
                    if (operation.getTargetPosition() != null && operation.getOperationTypeCode().equals("OPE_TYPE_BUY") && (double)amount >= 0.0) {
                        amount *= -1.0f;
                    }
                    previousBalance += amount;
                    this.detailsTable.addCell(((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.CENTER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.filteringAccount != null ? this.filteringAccount.getCurrency() : operation.getTargetAccount().getCurrency())));
                    this.detailsTable.addCell(((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.CENTER)).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph(amount < 0.0f ? this.configuration.getPriceFormatter().format(Math.abs(amount)) : " ")));
                    this.detailsTable.addCell(((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.CENTER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(amount >= 0.0f ? this.configuration.getPriceFormatter().format(Math.abs(amount)) : " ")));
                    this.detailsTable.addCell(((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.RIGHT)).setFontColor(previousBalance >= 0.0f ? this.configuration.getSequoiaGreen() : this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(previousBalance))));
                }
                ++n2;
            }
        }
        this.detailsTable.addCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, 5).setBorder(Border.NO_BORDER)).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.RIGHT)).setFontColor(this.configuration.getSequoiaGreen())).setBold()).add((BlockElement)new Paragraph("End of period balance")));
        this.detailsTable.addCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.RIGHT)).setFontColor(previousBalance >= 0.0f ? this.configuration.getSequoiaGreen() : this.configuration.getSequoiaRed())).setBold()).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(previousBalance))));
        return this.detailsTables;
    }
}

