/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report.model;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.Date;

public class MovementDetails
implements Serializable {
    private static final long serialVersionUID = -6420538651363623515L;
    private Date applicationDate;
    private double positive = 0.0;
    private double negative = 0.0;
    private double securityTransfer = 0.0;
    private double pnl = 0.0;
    private double fees = 0.0;
    private double loan = 0.0;
    private double buySellDifference = 0.0;

    public MovementDetails(JsonNode node) {
        if (node == null) {
            this.positive = 0.0;
            this.negative = 0.0;
            this.securityTransfer = 0.0;
            this.fees = 0.0;
            this.loan = 0.0;
            this.buySellDifference = 0.0;
            this.pnl = 0.0;
        } else {
            this.positive = node.get("positive").asDouble();
            this.negative = node.get("negative").asDouble();
            this.securityTransfer = node.get("sec_transfer").asDouble();
            this.fees = node.get("fees").asDouble();
            this.loan = node.get("loan").asDouble();
            this.buySellDifference = node.get("bs_difference").asDouble();
            this.pnl = node.get("pnl").asDouble();
        }
    }

    public double getCashMovement() {
        return this.positive + this.negative + this.securityTransfer + this.loan;
    }

    public double getImpactingMovement() {
        return this.fees + this.pnl;
    }

    public double getTotalNoBuySell() {
        return this.positive + this.negative + this.securityTransfer + this.loan + this.fees + this.pnl;
    }

    public double getTotal() {
        return this.positive + this.negative + this.securityTransfer + this.loan + this.fees + this.buySellDifference + this.pnl;
    }

    public Date getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = applicationDate;
    }

    public double getPositive() {
        return this.positive;
    }

    public void setPositive(double positive) {
        this.positive = positive;
    }

    public double getNegative() {
        return this.negative;
    }

    public void setNegative(double negative) {
        this.negative = negative;
    }

    public double getSecurityTransfer() {
        return this.securityTransfer;
    }

    public void setSecurityTransfer(double securityTransfer) {
        this.securityTransfer = securityTransfer;
    }

    public double getPnl() {
        return this.pnl;
    }

    public void setPnl(double pnl) {
        this.pnl = pnl;
    }

    public double getFees() {
        return this.fees;
    }

    public void setFees(double fees) {
        this.fees = fees;
    }

    public double getLoan() {
        return this.loan;
    }

    public void setLoan(double loan) {
        this.loan = loan;
    }

    public double getBuySellDifference() {
        return this.buySellDifference;
    }

    public void setBuySellDifference(double buySellDifference) {
        this.buySellDifference = buySellDifference;
    }
}

