/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.util.rabbitmq;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gso.finance.report.MainConstraintsReport;
import com.gso.finance.report.MainFinanceReport;
import com.gso.finance.report.MainFinanceReportSimplified;
import com.gso.finance.report.MainReport;
import com.gso.finance.report.MainSummaryReport;
import com.gso.finance.report.OperationAMLReport;
import com.gso.finance.report.OperationContractNote;
import com.gso.finance.report.PortfolioOperationsClientBilling;
import com.gso.finance.report.config.ReportsConfiguration;
import com.gso.finance.util.rabbitmq.RabbitController;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;

public class LocalLauncher {
    public static final String REPORTS_TAG = "reports";

    public static Options createCommandLineOptions() {
        Options options = new Options();
        options.addOption("conf_path", true, "Path to configuration files");
        options.addOption("conf_rabbit", true, "Name of the RabbitMQ configuration file");
        options.addOption("conf_reports", true, "Name of the RabbitMQ configuration file");
        options.addOption("ui_enable", false, "Activate the graphical user interface");
        options.addOption("console_input", false, "Activate the console user interaction");
        options.addOption("logs_debug", false, "Enable DEBUG level trace logs");
        options.addOption("logs_trace", false, "Enable TRACE level trace logs. Warning: can be really slow and disk space consuming");
        options.addOption("logs_path", true, "Path to logs storage");
        return options;
    }

    public static Path getConfigurationFile(CommandLine cli, String configurationTag) {
        if (cli.hasOption("conf_path") && cli.hasOption("conf_" + configurationTag)) {
            return Paths.get(cli.getOptionValue("conf_path"), cli.getOptionValue("conf_" + configurationTag));
        }
        return null;
    }

    public static void main(String[] argv) throws ParseException, IOException {
        Options options = LocalLauncher.createCommandLineOptions();
        BasicParser parser = new BasicParser();
        CommandLine cli = parser.parse(options, argv);
        Path reportsConfigPath = LocalLauncher.getConfigurationFile(cli, REPORTS_TAG);
        ReportsConfiguration reportsConfig = null;
        reportsConfig = new ReportsConfiguration(Files.newInputStream(reportsConfigPath, new OpenOption[0]));
        RabbitController.getInstance().setReportsConfiguration(reportsConfig);
        InputStream resourceAsStream = LocalLauncher.class.getResourceAsStream("test.json");
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)resourceAsStream, (Writer)writer, (String)"utf-8");
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(writer.toString());
        String reportGeneratorName = node.get("report_generator").asText();
        String reportPath = null;
        MainReport reportGenerator = null;
        if (reportGeneratorName.equals("MainFinanceReport")) {
            reportGenerator = new MainFinanceReport();
        } else if (reportGeneratorName.equals("MainConstraintsReport")) {
            reportGenerator = new MainConstraintsReport();
        } else if (reportGeneratorName.equals("MainSummaryReport")) {
            reportGenerator = new MainSummaryReport();
        } else if (reportGeneratorName.equals("MainFinanceReportSimplified")) {
            reportGenerator = new MainFinanceReportSimplified();
        } else if (reportGeneratorName.equals("OperationContractNote")) {
            reportGenerator = new OperationContractNote();
        } else if (reportGeneratorName.equals("PortfolioOperationsClientBilling")) {
            reportGenerator = new PortfolioOperationsClientBilling();
        } else if (reportGeneratorName.equals("OperationAMLDocument")) {
            reportGenerator = new OperationAMLReport();
        }
        if (reportGenerator != null) {
            reportPath = reportGenerator.generateReport(node.get("data"));
        }
        System.out.println(reportPath);
    }
}

