/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.util.rabbitmq;

import com.gso.config.RabbitConfiguration;
import com.gso.finance.report.config.ReportsConfiguration;
import com.gso.finance.util.rabbitmq.consumer.ReportsConsumer;
import com.gso.util.rabbitmq.exception.RabbitConfigurationNotSetException;
import com.gso.util.rabbitmq.exception.RabbitConnectionAlreadyClosedException;
import com.gso.util.rabbitmq.impl.ChannelErrorListener;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.ConsumerCancelledException;
import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class RabbitController {
    public static final String REPORTS_TAG = "reports";
    public static final String RABBIT_TAG = "rabbit";
    private static Logger LOGGER = Logger.getLogger(RabbitController.class);
    private static RabbitController instance = null;
    private RabbitConfiguration configuration = null;
    private ReportsConfiguration reportsConfiguration = null;
    private Connection connection = null;
    private Channel channel = null;
    private String requestQueueName = null;
    private Boolean controllerActive = Boolean.TRUE;

    private RabbitController() {
    }

    public static RabbitController getInstance() {
        if (instance == null) {
            instance = new RabbitController();
        }
        return instance;
    }

    /*
     * Unable to fully structure code
     */
    public void start() throws RabbitConfigurationNotSetException, IOException {
        if (this.configuration != null) ** GOTO lbl23
        throw new RabbitConfigurationNotSetException("The Rabbit MQ configuration has not been set!");
lbl-1000:
        // 1 sources

        {
            try {
                RabbitController.LOGGER.debug((Object)"Connecting to RabbitMQ server");
                this.connect();
                RabbitController.LOGGER.debug((Object)"Subscribing to Reports queue ");
                this.subscribe();
                continue;
            }
            catch (IOException e) {
                RabbitController.LOGGER.warn((Object)"Could not wait, restart");
                if (this.channel.isOpen()) {
                    try {
                        this.channel.close();
                    }
                    catch (AlreadyClosedException ace) {
                        RabbitController.LOGGER.debug((Object)"Channel was already closed");
                    }
                }
                if (!this.connection.isOpen()) continue;
                try {
                    this.connection.close();
                    continue;
                }
                catch (AlreadyClosedException ace) {
                    RabbitController.LOGGER.debug((Object)"Connection was already closed");
                }
            }
lbl23:
            // 5 sources

            ** while (this.controllerActive.booleanValue())
        }
lbl24:
        // 1 sources

    }

    public void stop() throws RabbitConnectionAlreadyClosedException, IOException {
        if (this.channel == null || !this.channel.isOpen()) {
            throw new RabbitConnectionAlreadyClosedException("The channel is already closed!");
        }
        this.channel.close();
        if (this.connection == null || !this.connection.isOpen()) {
            throw new RabbitConnectionAlreadyClosedException("The connection is already closed!");
        }
        this.connection.close();
    }

    protected void subscribe() throws IOException {
        QueueingConsumer mainConsumer = new QueueingConsumer(this.channel);
        this.channel.basicConsume(this.requestQueueName, false, (Consumer)mainConsumer);
        try {
            while (this.controllerActive.booleanValue()) {
                LOGGER.info((Object)"Entering wait mode");
                if (!this.channel.isOpen()) {
                    try {
                        this.channel.close();
                    }
                    catch (Exception e) {
                        LOGGER.info((Object)"Channel was closed, reopening");
                    }
                    try {
                        this.connection.close();
                    }
                    catch (Exception e) {
                        LOGGER.info((Object)"Connection was closed, reopening");
                    }
                    this.connect();
                }
                QueueingConsumer.Delivery delivery = mainConsumer.nextDelivery();
                ReportsConsumer consumer = new ReportsConsumer(delivery, this.channel);
                Thread thread = new Thread(consumer);
                thread.start();
                thread.join();
            }
        }
        catch (ShutdownSignalException e) {
            throw new IOException("Shutdown signal related error", e);
        }
        catch (ConsumerCancelledException e) {
            throw new IOException("Consumer cancelled the process", e);
        }
        catch (InterruptedException e) {
            throw new IOException("An unexpected error occured", e);
        }
    }

    protected void connect() throws IOException {
        LOGGER.debug((Object)"Initializing RabbitMQ connection factory");
        ConnectionFactory cf = new ConnectionFactory();
        cf.setUsername(this.configuration.getUser());
        cf.setPassword(this.configuration.getPassword());
        cf.setVirtualHost(this.configuration.getVirtualHost());
        cf.setHost(this.configuration.getHost());
        cf.setPort(this.configuration.getPort());
        LOGGER.info((Object)String.format("Connecting to amqp://%s:*****@%s:%d/%s", this.configuration.getUser(), this.configuration.getHost(), this.configuration.getPort(), this.configuration.getVirtualHost()));
        this.connection = cf.newConnection();
        LOGGER.info((Object)"Creating Rabbit MQ channel");
        this.channel = this.connection.createChannel();
        LOGGER.info((Object)("Channel created [" + this.channel.toString() + "]"));
        LOGGER.info((Object)"Creating queue");
        this.requestQueueName = this.channel.queueDeclare(this.reportsConfiguration.getRequestQueueName(), false, false, false, new HashMap()).getQueue();
        this.channel.addShutdownListener((ShutdownListener)new ChannelErrorListener());
        LOGGER.info((Object)("Queue " + this.requestQueueName + " has been created"));
    }

    public boolean isControllerActive() {
        return this.controllerActive;
    }

    public void setControllerActive(boolean controllerActive) {
        this.controllerActive = controllerActive;
    }

    public RabbitController setConfiguration(RabbitConfiguration configuration) {
        LOGGER.debug((Object)"New configuration has been assigned");
        this.configuration = configuration;
        return this;
    }

    public ReportsConfiguration getReportsConfiguration() {
        return this.reportsConfiguration;
    }

    public void setReportsConfiguration(ReportsConfiguration reportsConfiguration) {
        this.reportsConfiguration = reportsConfiguration;
    }

    public static void configureLogging(CommandLine cli) {
        Level logLevel = Level.INFO;
        String logRabbitFileName = "RabbitMQ-Reports.log";
        boolean console = false;
        if (cli.hasOption("logs_debug")) {
            logLevel = Level.DEBUG;
        }
        if (cli.hasOption("logs_trace")) {
            logLevel = Level.TRACE;
        }
        if (cli.hasOption("console_input")) {
            console = true;
        }
        String logRootPathName = "";
        if (cli.hasOption("logs_path") && !(logRootPathName = cli.getOptionValue("logs_path")).endsWith(File.separator)) {
            logRootPathName = String.valueOf(logRootPathName) + File.separator;
        }
        Logger rootLogger = Logger.getLogger((String)"com.gso");
        rootLogger.setLevel(logLevel);
        if (!console) {
            rootLogger.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%d{dd MMM yy  HH:mm:ss} %-48C{1} %-5p:  %m%n")));
        }
        try {
            rootLogger.addAppender((Appender)new FileAppender((Layout)new PatternLayout("%d{dd MMM yy  HH:mm:ss} %-48C{1} %-5p:  %m%n"), logRabbitFileName, false));
        }
        catch (IOException e) {
            LOGGER.info((Object)"Could not open logging file.", (Throwable)e);
        }
    }

    public static Path getConfigurationFile(CommandLine cli, String configurationTag) {
        if (cli.hasOption("conf_path") && cli.hasOption("conf_" + configurationTag)) {
            return Paths.get(cli.getOptionValue("conf_path"), cli.getOptionValue("conf_" + configurationTag));
        }
        return null;
    }

    public static Options createCommandLineOptions() {
        Options options = new Options();
        options.addOption("conf_path", true, "Path to configuration files");
        options.addOption("conf_rabbit", true, "Name of the RabbitMQ configuration file");
        options.addOption("conf_reports", true, "Name of the RabbitMQ configuration file");
        options.addOption("ui_enable", false, "Activate the graphical user interface");
        options.addOption("console_input", false, "Activate the console user interaction");
        options.addOption("logs_debug", false, "Enable DEBUG level trace logs");
        options.addOption("logs_trace", false, "Enable TRACE level trace logs. Warning: can be really slow and disk space consuming");
        options.addOption("logs_path", true, "Path to logs storage");
        return options;
    }

    public static void main(String[] argv) throws ParseException {
        Options options = RabbitController.createCommandLineOptions();
        BasicParser parser = new BasicParser();
        CommandLine cli = parser.parse(options, argv);
        Path rabbitConfigPath = RabbitController.getConfigurationFile(cli, RABBIT_TAG);
        Path reportsConfigPath = RabbitController.getConfigurationFile(cli, REPORTS_TAG);
        RabbitController.configureLogging(cli);
        boolean canStart = true;
        if (rabbitConfigPath == null || reportsConfigPath == null) {
            canStart = false;
        }
        RabbitConfiguration rabbitConfig = null;
        ReportsConfiguration reportsConfig = null;
        if (canStart) {
            try {
                rabbitConfig = new RabbitConfiguration(Files.newInputStream(rabbitConfigPath, new OpenOption[0]));
                reportsConfig = new ReportsConfiguration(Files.newInputStream(reportsConfigPath, new OpenOption[0]));
            }
            catch (IOException e) {
                LOGGER.error((Object)"One or more configuration files could not be found or opened, please check the command line arguments.");
                canStart = false;
            }
        }
        if (canStart) {
            LOGGER.info((Object)"Setting up RabbitMQ controller for Bloomberg");
            RabbitController controller = RabbitController.getInstance().setConfiguration(rabbitConfig);
            controller.setReportsConfiguration(reportsConfig);
            LOGGER.info((Object)"\tRabbitMQ controller created");
            try {
                LOGGER.info((Object)"Starting RabbitMQ controller");
                controller.start();
                LOGGER.info((Object)"RabbitMQ controller started");
            }
            catch (RabbitConfigurationNotSetException e) {
                LOGGER.error((Object)"The RabbitMQ controller configuration is not set.");
            }
            catch (IOException e) {
                LOGGER.error((Object)"Network or file system error during RabbitMQ client set up.", (Throwable)e);
            }
        } else {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("RabbitController", options);
            return;
        }
    }
}

