/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.util.rabbitmq;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gso.finance.report.MainConstraintsReport;
import com.gso.finance.report.MainFinanceReport;
import com.gso.finance.report.MainFinanceReportSimplified;
import com.gso.finance.report.MainReport;
import com.gso.finance.report.MainSummaryReport;
import com.gso.finance.report.OperationAMLReport;
import com.gso.finance.report.OperationContractNote;
import com.gso.finance.report.PortfolioOperationsClientBilling;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class ReportHttpHandler
implements HttpHandler {
    @Override
    public void handle(HttpExchange exchange) {
        try {
            if (exchange.getRequestMethod().equalsIgnoreCase("POST")) {
                try {
                    InputStream requestBody = exchange.getRequestBody();
                    String content = IOUtils.toString((InputStream)requestBody, (String)"utf-8");
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode node = mapper.readTree(content);
                    String reportGeneratorName = node.get("report_generator").asText();
                    String reportPath = null;
                    MainReport reportGenerator = null;
                    if (reportGeneratorName.equals("MainFinanceReport")) {
                        reportGenerator = new MainFinanceReport();
                    } else if (reportGeneratorName.equals("MainConstraintsReport")) {
                        reportGenerator = new MainConstraintsReport();
                    } else if (reportGeneratorName.equals("MainSummaryReport")) {
                        reportGenerator = new MainSummaryReport();
                    } else if (reportGeneratorName.equals("MainFinanceReportSimplified")) {
                        reportGenerator = new MainFinanceReportSimplified();
                    } else if (reportGeneratorName.equals("OperationContractNote")) {
                        reportGenerator = new OperationContractNote();
                    } else if (reportGeneratorName.equals("PortfolioOperationsClientBilling")) {
                        reportGenerator = new PortfolioOperationsClientBilling();
                    } else if (reportGeneratorName.equals("OperationAMLDocument")) {
                        reportGenerator = new OperationAMLReport();
                    }
                    if (reportGenerator != null) {
                        reportPath = reportGenerator.generateReport(node.get("data"));
                    }
                    exchange.sendResponseHeaders(200, reportPath.getBytes().length);
                    OutputStream responseBody = exchange.getResponseBody();
                    responseBody.write(reportPath.getBytes());
                    responseBody.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    exchange.sendResponseHeaders(400, e.getMessage().getBytes().length);
                    OutputStream responseBody = exchange.getResponseBody();
                    responseBody.write(e.getMessage().getBytes());
                    responseBody.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

