/*
 * Decompiled with CFR 0.152.
 */
package com.gso.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class AbstractConfiguration
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(AbstractConfiguration.class);
    private static final long serialVersionUID = 3403614148212942854L;
    public static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");

    public AbstractConfiguration() {
        this.initialize();
    }

    protected abstract void initialize();

    public void overrideDefaults(InputStream stream) throws IOException {
        InputStreamReader reader = new InputStreamReader(stream);
        BufferedReader br = new BufferedReader(reader);
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] data = new String[2];
            int index = line.indexOf("=");
            if (index != -1) {
                try {
                    data[0] = line.substring(0, index).trim();
                    data[1] = line.substring(index + 1).trim();
                    Field field = this.getClass().getDeclaredField(data[0].trim());
                    field.setAccessible(true);
                    Class<?> type = field.getType();
                    Object value = null;
                    if (type == Integer.class || type == Integer.TYPE) {
                        value = new Integer(data[1].trim());
                    } else if (type == Double.class || type == Double.TYPE) {
                        value = new Double(data[1].trim());
                    } else if (type == Boolean.class || type == Boolean.TYPE) {
                        value = new Boolean(data[1]);
                    } else if (type == String.class) {
                        value = data[1];
                    } else if (type == Date.class) {
                        try {
                            value = DATE_FORMATTER.parse(data[1]);
                        }
                        catch (ParseException e) {
                            LOGGER.error((Object)"The date value is not in the proper format", (Throwable)e);
                        }
                    }
                    field.set(this, value);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    LOGGER.error((Object)"The configuration cannot be written", (Throwable)e);
                }
                continue;
            }
            LOGGER.warn((Object)("The current line [" + line + "] does not contain a key/value pair in the proper format"));
        }
        br.close();
        reader.close();
        stream.close();
    }
}

