/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report;

import com.fasterxml.jackson.databind.JsonNode;
import com.gso.finance.report.MainReport;
import com.gso.finance.report.block.ConstraintsDetails;
import com.gso.finance.report.config.ReportsConfiguration;
import com.gso.finance.report.header.DefaultDocumentHeader;
import com.gso.finance.report.model.ConstraintsResults;
import com.gso.finance.report.model.ReportInformation;
import com.gso.finance.util.rabbitmq.RabbitController;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.AreaBreak;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.AreaBreakType;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MainConstraintsReport
implements MainReport {
    @Override
    public String generateReport(JsonNode data) {
        String documentPath = "";
        try {
            ReportInformation reportInformation = new ReportInformation(data.get("report"));
            ReportsConfiguration configuration = RabbitController.getInstance().getReportsConfiguration();
            ConstraintsResults[] crs = ConstraintsResults.fromJsonNode(data.get("results"));
            documentPath = String.valueOf(configuration.getWorkingPath()) + reportInformation.getReportName() + "-" + configuration.getDateFormatter().format(reportInformation.getWorkingDate()) + ".pdf";
            FileOutputStream fos = new FileOutputStream(documentPath);
            PdfWriter writer = new PdfWriter((OutputStream)fos);
            PdfFont defaultFont = PdfFontFactory.createFont((String)(String.valueOf(configuration.getResourcesPath()) + configuration.getDefaultFont()));
            PdfDocument pdf = new PdfDocument(writer);
            Document document = new Document(pdf, PageSize.A4.rotate());
            document.setFont(defaultFont);
            document.setMargins(15.0f, 15.0f, 15.0f, 15.0f);
            Table header = new DefaultDocumentHeader(configuration, reportInformation, reportInformation.getReportName()).getHeader();
            int size = crs.length;
            int count = 0;
            ConstraintsResults[] constraintsResultsArray = crs;
            int n = crs.length;
            int n2 = 0;
            while (n2 < n) {
                ConstraintsResults cr = constraintsResultsArray[n2];
                ++count;
                Table content = new ConstraintsDetails(configuration, cr.getPortfolio(), cr.getResults()).getDetailsTable();
                document.add((BlockElement)header);
                document.add((BlockElement)content);
                if (count < size) {
                    document.add(new AreaBreak(AreaBreakType.NEXT_PAGE));
                }
                ++n2;
            }
            document.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return documentPath;
    }
}

