/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report;

import com.fasterxml.jackson.databind.JsonNode;
import com.gso.finance.report.MainReport;
import com.gso.finance.report.block.CashAccountsDetails;
import com.gso.finance.report.block.DefaultAssetsDetails;
import com.gso.finance.report.block.PieChartBreakdown;
import com.gso.finance.report.block.SimplifiedPortfolioPerformancesTable;
import com.gso.finance.report.block.SimplifiedPositionsDetails;
import com.gso.finance.report.config.ReportsConfiguration;
import com.gso.finance.report.header.DefaulPortfolioHeader;
import com.gso.finance.report.model.Portfolio;
import com.gso.finance.report.model.ReportInformation;
import com.gso.finance.util.rabbitmq.RabbitController;
import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.border.SolidBorder;
import com.itextpdf.layout.element.AreaBreak;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.AreaBreakType;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.UUID;

public class MainFinanceReportSimplified
implements MainReport {
    @Override
    public String generateReport(JsonNode data) {
        Portfolio portfolio = new Portfolio(data.get("portfolio"));
        ReportInformation report = new ReportInformation(data.get("report"));
        String documentPath = "";
        try {
            ReportsConfiguration configuration = RabbitController.getInstance().getReportsConfiguration();
            documentPath = String.valueOf(configuration.getWorkingPath()) + portfolio.getName().replace('/', '-').replace('\\', '-') + "-" + UUID.randomUUID().toString() + ".pdf";
            FileOutputStream fos = new FileOutputStream(documentPath);
            PdfWriter writer = new PdfWriter((OutputStream)fos);
            PdfFont defaultFont = PdfFontFactory.createFont((String)(String.valueOf(configuration.getResourcesPath()) + configuration.getDefaultFont()));
            PdfDocument pdf = new PdfDocument(writer);
            Document document = new Document(pdf, PageSize.A4.rotate());
            document.setFont(defaultFont);
            document.setMargins(15.0f, 15.0f, 15.0f, 15.0f);
            Table header = new DefaulPortfolioHeader(configuration, report, portfolio, "Portfolio Summary").getHeader();
            document.add((BlockElement)header);
            Table breakdownTable = new Table(new float[]{10.0f, 6.0f, 10.0f});
            breakdownTable.setBorder((Border)new SolidBorder(Color.GRAY, 0.01f));
            breakdownTable.setWidthPercent(100.0f);
            breakdownTable.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBorderRight((Border)new SolidBorder(Color.GRAY, 0.01f))).add(new PieChartBreakdown(configuration, portfolio, portfolio.getSecurityTypeBreakdown(), "Asset Class Breakdown", 6).getBreakdownsTable()));
            breakdownTable.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBorderLeft((Border)new SolidBorder(Color.GRAY, 0.01f))).setBorderRight((Border)new SolidBorder(Color.GRAY, 0.01f))).add(new DefaultAssetsDetails(configuration, report, portfolio, "Total Asset").getDetailsTable()));
            breakdownTable.addCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBorderLeft((Border)new SolidBorder(Color.GRAY, 0.01f))).add(new PieChartBreakdown(configuration, portfolio, portfolio.getCurrencyBreakdown(), "Currency Breakdown", 6).getBreakdownsTable()));
            document.add((BlockElement)breakdownTable);
            document.add((BlockElement)new SimplifiedPortfolioPerformancesTable(configuration, portfolio, report).getDetailsTable());
            document.add(new AreaBreak(AreaBreakType.NEXT_PAGE));
            document.add((BlockElement)header);
            document.add((BlockElement)new CashAccountsDetails(configuration, portfolio, "ACCOUNTS", true).getDetailsTable(portfolio.getSubPortfolios().length > 0));
            if (portfolio.getCurrentPositions().length > 0) {
                ArrayList<Table> tables = new SimplifiedPositionsDetails(configuration, portfolio, portfolio.getSubPortfolios().length > 0 ? "CONSOLIDATED POSITIONS" : "POSITIONS").getDetailsTables();
                for (Table table : tables) {
                    document.add(new AreaBreak(AreaBreakType.NEXT_PAGE));
                    document.add((BlockElement)header);
                    document.add((BlockElement)table);
                }
            }
            Portfolio[] portfolioArray = portfolio.getSubPortfolios();
            int n = portfolioArray.length;
            int n2 = 0;
            while (n2 < n) {
                Portfolio subPortfolio = portfolioArray[n2];
                if (subPortfolio.getCurrentPositions().length > 0) {
                    ArrayList<Table> tables = new SimplifiedPositionsDetails(configuration, subPortfolio, String.valueOf(subPortfolio.getBank()) + " - POSITIONS").getDetailsTables();
                    for (Table table : tables) {
                        document.add(new AreaBreak(AreaBreakType.NEXT_PAGE));
                        document.add((BlockElement)header);
                        document.add((BlockElement)table);
                    }
                }
                ++n2;
            }
            document.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return documentPath;
    }
}

