/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report.block;

import com.gso.finance.report.config.ReportsConfiguration;
import com.gso.finance.report.model.Operation;
import com.gso.finance.report.model.Portfolio;
import com.gso.finance.report.model.ThirdParty;
import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.border.SolidBorder;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.TextAlignment;

public class BuySellOperationDetails {
    private ReportsConfiguration configuration;
    private Portfolio portfolio;
    private Operation operation;
    private Table detailsTable = null;

    public BuySellOperationDetails(ReportsConfiguration configuration, Portfolio portfolio, Operation operation) {
        this.configuration = configuration;
        this.portfolio = portfolio;
        this.operation = operation;
    }

    public Table getDetailsTable() {
        if (this.detailsTable == null) {
            this.detailsTable = new Table(new float[]{2.0f, 3.0f, 2.0f, 3.0f});
            this.detailsTable.setWidthPercent(100.0f);
            this.detailsTable.setTextAlignment(TextAlignment.LEFT);
            this.detailsTable.setBorder((Border)new SolidBorder(Color.GRAY, 0.01f));
            this.detailsTable.setFontSize(10.0f);
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph("Bank:")));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell(1, 3).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.portfolio.getBank())));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph("Client:")));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell(1, 3).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(String.valueOf(this.portfolio.getName()) + " / " + this.portfolio.getCode())));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph("Contact:")));
            int count = 0;
            ThirdParty[] thirdPartyArray = this.portfolio.getContacts();
            int n = thirdPartyArray.length;
            int n2 = 0;
            while (n2 < n) {
                ThirdParty contact = thirdPartyArray[n2];
                if (this.portfolio.getContacts().length == 1) {
                    this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell(1, 3).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(contact.getName()).setAction(PdfAction.createURI((String)("mailto:" + contact.getEmail())))));
                    break;
                }
                if (count == 0) {
                    this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(contact.getName()).setAction(PdfAction.createURI((String)("mailto:" + contact.getEmail())))));
                } else {
                    this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph(" or ")));
                    this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(contact.getName()).setAction(PdfAction.createURI((String)("mailto:" + contact.getEmail())))));
                }
                if (++count > 1) break;
                ++n2;
            }
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph("Generated by:")));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.operation.getOperator())));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph(" the ")));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.configuration.getDateTimeFormatter().format(this.operation.getInputDate()))));
            if (this.operation.getOperationStatus().equals("Cancelled")) {
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph("Cancelled by:")));
            } else {
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph("Sent by:")));
            }
            if (!this.operation.getValidator().equals("N/A")) {
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.operation.getValidator())));
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph(" the ")));
                if (this.operation.getOperationStatus().equals("Cancelled")) {
                    this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.operation.getCancelDate() != null ? this.configuration.getDateTimeFormatter().format(this.operation.getCancelDate()) : "N/A")));
                } else {
                    this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.operation.getSentDate() != null ? this.configuration.getDateTimeFormatter().format(this.operation.getSentDate()) : "N/A")));
                }
            } else {
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell(1, 3).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph("N/A")));
            }
            this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell(1, 4).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).add((BlockElement)new Paragraph(" ")));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell(1, 4).setBorder(Border.NO_BORDER)).setFontSize(14.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph("Please execute the following security order according to the given instructions:")));
            this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell(1, 4).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).add((BlockElement)new Paragraph(" ")));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph("Name:")));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell(1, 3).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.operation.getTargetPosition().getName())));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph("ISIN:")));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell(1, 3).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.operation.getTargetPosition().getCode())));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph("Ticker:")));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell(1, 3).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.operation.getTargetPosition().getBloomberg())));
            this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell(1, 4).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).add((BlockElement)new Paragraph(" ")));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph("Type:")));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell(1, 3).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.operation.getOperationType())));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph("Action:")));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell(1, 3).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.operation.getOrderType())));
            boolean displayLimitPrice = false;
            boolean displayLimitDate = false;
            boolean displayStop = false;
            if (!this.operation.getOrderType().equals("At market")) {
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph("Duration:")));
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell(1, 3).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.operation.getOrderDuration())));
                if (this.operation.getOrderDuration().equals("Good till date")) {
                    displayLimitDate = true;
                }
                if (this.operation.getOrderType().equals("Stop Loss")) {
                    displayStop = true;
                }
                if (this.operation.getOrderType().equals("Stop Limit")) {
                    displayLimitPrice = true;
                    displayStop = true;
                }
                if (this.operation.getOrderType().equals("Limit")) {
                    displayLimitPrice = true;
                }
            } else {
                this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell(1, 4).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).add((BlockElement)new Paragraph(" ")));
            }
            this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell(1, 4).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).add((BlockElement)new Paragraph(" ")));
            if (this.operation.getTargetPosition().isQuantityBased()) {
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph("Quantity:")));
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell(1, 3).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(this.operation.getQuantity()))));
            } else {
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph("Amount:")));
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell(1, 3).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(this.operation.getAmount()))));
            }
            if (displayLimitPrice) {
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph("Limit price:")));
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell(1, 3).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(String.valueOf(this.configuration.getPriceFormatter().format(this.operation.getLimitPrice())) + " " + this.operation.getTargetPosition().getCurrency())));
            } else {
                this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell(1, 4).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).add((BlockElement)new Paragraph(" ")));
            }
            if (displayLimitDate && this.operation.getLimitDate() != null) {
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph("Limit date:")));
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell(1, 3).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.configuration.getDateFormatter().format(this.operation.getLimitDate()))));
            } else {
                this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell(1, 4).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).add((BlockElement)new Paragraph(" ")));
            }
            if (displayStop) {
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph("Stop price:")));
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell(1, 3).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(String.valueOf(this.configuration.getPriceFormatter().format(this.operation.getStopPrice())) + " " + this.operation.getTargetPosition().getCurrency())));
            } else {
                this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell(1, 4).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).add((BlockElement)new Paragraph(" ")));
            }
            if (this.operation.getDescription() != "") {
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)new Cell(1, 4).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setBold()).setFontColor(this.configuration.getSequoiaRed())).add((BlockElement)new Paragraph("Comment:")));
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell(1, 4).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setHeight(150.0f)).add((BlockElement)new Paragraph(this.operation.getDescription())));
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell(1, 4).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setHeight(200.0f)).add((BlockElement)new Paragraph(" ")));
            } else {
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell(1, 4).setBorder(Border.NO_BORDER)).setFontSize(10.0f)).setHeight(360.0f)).add((BlockElement)new Paragraph(" ")));
            }
        }
        return this.detailsTable;
    }

    public void setDetailsTable(Table detailsTable) {
        this.detailsTable = detailsTable;
    }
}

