/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report.block;

import com.gso.finance.report.config.ReportsConfiguration;
import com.gso.finance.report.model.MovementDetails;
import com.gso.finance.report.model.Portfolio;
import com.gso.finance.report.utility.DateUtil;
import com.itextpdf.kernel.color.Color;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.border.SolidBorder;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.TextAlignment;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class MonthlyMovementsSummary {
    private ReportsConfiguration configuration;
    private Portfolio portfolio;
    private Table detailsTable = null;
    private SimpleDateFormat tableDateFormatter = new SimpleDateFormat("MMM-yy");
    private String title = "";

    public MonthlyMovementsSummary(ReportsConfiguration configuration, Portfolio portfolio, String title) {
        this.configuration = configuration;
        this.portfolio = portfolio;
        this.title = title;
    }

    public Table getDetailsTable() {
        if (this.detailsTable == null) {
            MovementDetails movementDetails;
            Date workDate;
            Date workDate2;
            this.detailsTable = new Table(new float[]{2.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f});
            this.detailsTable.setBorder((Border)new SolidBorder(Color.GRAY, 0.01f));
            this.detailsTable.setWidthPercent(100.0f);
            this.detailsTable.setTextAlignment(TextAlignment.RIGHT);
            this.detailsTable.setFontSize(6.0f);
            Date startDate = DateUtil.addOrRemoveMonths(this.portfolio.getWorkingDate(), -11);
            int shift = 0;
            int month = 0;
            while (month < 12) {
                workDate2 = DateUtil.getEndOfMonth(DateUtil.addOrRemoveMonths(startDate, month));
                if (this.portfolio.getTracks().get("MONTHLY_PERFORMANCE").get(workDate2) == null) {
                    ++shift;
                }
                ++month;
            }
            startDate = DateUtil.addOrRemoveMonths(startDate, shift);
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, 14).setBorder(Border.NO_BORDER)).setBold()).setFontSize(8.0f)).setBackgroundColor(this.configuration.getSequoiaGreen())).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph(this.title)));
            this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell(1, 14).setBorder(Border.NO_BORDER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("")));
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBackgroundColor(this.configuration.getSequoiaGreen())).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("")));
            month = 0;
            while (month < 12) {
                workDate2 = DateUtil.addOrRemoveMonths(DateUtil.getEndOfMonth(startDate), month);
                Paragraph monthElement = new Paragraph(this.tableDateFormatter.format(workDate2));
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBackgroundColor(this.configuration.getSequoiaGreen())).setFontColor(Color.WHITE)).add((BlockElement)monthElement));
                ++month;
            }
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBackgroundColor(this.configuration.getSequoiaGreen())).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("TOTAL")));
            Paragraph noDataElement = new Paragraph("-");
            noDataElement.setFontSize(4.0f);
            HashMap<Date, MovementDetails> allDetails = this.portfolio.getMovementsDetails();
            float total = 0.0f;
            this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph("Withdrawals:")));
            int month2 = 0;
            while (month2 < 12) {
                workDate = DateUtil.getEndOfMonth(DateUtil.addOrRemoveMonths(startDate, month2));
                movementDetails = allDetails.get(workDate);
                if (movementDetails == null) {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
                } else {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(movementDetails.getNegative()))));
                    total = (float)((double)total + movementDetails.getNegative());
                }
                ++month2;
            }
            if (total != 0.0f) {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(total))));
            } else {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
            }
            total = 0.0f;
            this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph("Fees:")));
            month2 = 0;
            while (month2 < 12) {
                workDate = DateUtil.getEndOfMonth(DateUtil.addOrRemoveMonths(startDate, month2));
                movementDetails = allDetails.get(workDate);
                if (movementDetails == null) {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
                } else {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(movementDetails.getFees()))));
                    total = (float)((double)total + movementDetails.getFees());
                }
                ++month2;
            }
            if (total != 0.0f) {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(total))));
            } else {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
            }
            total = 0.0f;
            this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph("Contributions:")));
            month2 = 0;
            while (month2 < 12) {
                workDate = DateUtil.getEndOfMonth(DateUtil.addOrRemoveMonths(startDate, month2));
                movementDetails = allDetails.get(workDate);
                if (movementDetails == null) {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
                } else {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(movementDetails.getPositive()))));
                    total = (float)((double)total + movementDetails.getPositive());
                }
                ++month2;
            }
            if (total != 0.0f) {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(total))));
            } else {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
            }
            total = 0.0f;
            this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph("Coupons/Dividends/Accrued/...:")));
            month2 = 0;
            while (month2 < 12) {
                workDate = DateUtil.getEndOfMonth(DateUtil.addOrRemoveMonths(startDate, month2));
                movementDetails = allDetails.get(workDate);
                if (movementDetails == null) {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
                } else {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(movementDetails.getPnl()))));
                    total = (float)((double)total + movementDetails.getPnl());
                }
                ++month2;
            }
            if (total != 0.0f) {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(total))));
            } else {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
            }
            total = 0.0f;
            this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph("Loans:")));
            month2 = 0;
            while (month2 < 12) {
                workDate = DateUtil.getEndOfMonth(DateUtil.addOrRemoveMonths(startDate, month2));
                movementDetails = allDetails.get(workDate);
                if (movementDetails == null) {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
                } else {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(movementDetails.getLoan()))));
                    total = (float)((double)total + movementDetails.getLoan());
                }
                ++month2;
            }
            if (total != 0.0f) {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(total))));
            } else {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
            }
            total = 0.0f;
            this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph("Transferred securities (in/out):")));
            month2 = 0;
            while (month2 < 12) {
                workDate = DateUtil.getEndOfMonth(DateUtil.addOrRemoveMonths(startDate, month2));
                movementDetails = allDetails.get(workDate);
                if (movementDetails == null) {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
                } else {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(movementDetails.getSecurityTransfer()))));
                    total = (float)((double)total + movementDetails.getSecurityTransfer());
                }
                ++month2;
            }
            if (total != 0.0f) {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(total))));
            } else {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
            }
            total = 0.0f;
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontColor(this.configuration.getSequoiaGreen())).setBold()).add((BlockElement)new Paragraph("TOTAL MOVEMENTS:")));
            month2 = 0;
            while (month2 < 12) {
                workDate = DateUtil.getEndOfMonth(DateUtil.addOrRemoveMonths(startDate, month2));
                movementDetails = allDetails.get(workDate);
                if (movementDetails == null) {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
                } else {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(movementDetails.getTotalNoBuySell()))));
                    total = (float)((double)total + movementDetails.getTotalNoBuySell());
                }
                ++month2;
            }
            if (total != 0.0f) {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(total))));
            } else {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
            }
            total = 0.0f;
            this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph("Bought/sold securities:")));
            month2 = 0;
            while (month2 < 12) {
                workDate = DateUtil.getEndOfMonth(DateUtil.addOrRemoveMonths(startDate, month2));
                movementDetails = allDetails.get(workDate);
                if (movementDetails == null) {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
                } else {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(movementDetails.getBuySellDifference()))));
                    total = (float)((double)total + movementDetails.getBuySellDifference());
                }
                ++month2;
            }
            if (total != 0.0f) {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(total))));
            } else {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
            }
            total = 0.0f;
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontColor(this.configuration.getSequoiaGreen())).setBold()).add((BlockElement)new Paragraph("OVERALL MOVEMENTS:")));
            month2 = 0;
            while (month2 < 12) {
                workDate = DateUtil.getEndOfMonth(DateUtil.addOrRemoveMonths(startDate, month2));
                movementDetails = allDetails.get(workDate);
                if (movementDetails == null) {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
                } else {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(movementDetails.getTotal()))));
                    total = (float)((double)total + movementDetails.getTotal());
                }
                ++month2;
            }
            if (total != 0.0f) {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(total))));
            } else {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
            }
        }
        return this.detailsTable;
    }
}

