/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report.block;

import com.gso.finance.report.config.ReportsConfiguration;
import com.gso.finance.report.model.Portfolio;
import com.gso.finance.report.model.ReportInformation;
import com.gso.finance.report.utility.DateUtil;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.border.SolidBorder;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.TextAlignment;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.DateTickUnitType;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

public class SimplifiedPortfolioPerformancesTable {
    private ReportsConfiguration configuration;
    private Portfolio portfolio;
    private Table detailsTable = null;
    private ReportInformation report;
    private SimpleDateFormat tableDateFormatter = new SimpleDateFormat("MMM-YY");

    public SimplifiedPortfolioPerformancesTable(ReportsConfiguration configuration, Portfolio portfolio, ReportInformation report) {
        this.configuration = configuration;
        this.portfolio = portfolio;
        this.report = report;
    }

    public Table getDetailsTable() {
        if (this.detailsTable == null) {
            Float value;
            Date workDate;
            Date workDate2;
            this.detailsTable = new Table(new float[]{2.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f});
            this.detailsTable.setBorder((Border)new SolidBorder(com.itextpdf.kernel.color.Color.GRAY, 0.01f));
            this.detailsTable.setWidthPercent(100.0f);
            this.detailsTable.setTextAlignment(TextAlignment.RIGHT);
            this.detailsTable.setFontSize(6.0f);
            Date startDate = DateUtil.addOrRemoveMonths(this.portfolio.getWorkingDate(), -11);
            int shift = 0;
            int month = 0;
            while (month < 12) {
                workDate2 = DateUtil.getEndOfMonth(DateUtil.addOrRemoveMonths(startDate, month));
                if (this.portfolio.getTracks().get("MONTHLY_PERFORMANCE").get(workDate2) == null) {
                    ++shift;
                }
                ++month;
            }
            startDate = DateUtil.addOrRemoveMonths(startDate, shift);
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBackgroundColor(this.configuration.getSequoiaGreen())).setFontColor(com.itextpdf.kernel.color.Color.WHITE)).add((BlockElement)new Paragraph("")));
            month = 0;
            while (month < 12) {
                workDate2 = DateUtil.addOrRemoveMonths(DateUtil.getEndOfMonth(startDate), month);
                Paragraph monthElement = new Paragraph(this.tableDateFormatter.format(workDate2));
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBackgroundColor(this.configuration.getSequoiaGreen())).setFontColor(com.itextpdf.kernel.color.Color.WHITE)).add((BlockElement)monthElement));
                ++month;
            }
            this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBackgroundColor(this.configuration.getSequoiaGreen())).setFontColor(com.itextpdf.kernel.color.Color.WHITE)).add((BlockElement)new Paragraph("TOTAL")));
            Paragraph noDataElement = new Paragraph("-");
            noDataElement.setFontSize(4.0f);
            this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph("Initial Value:")));
            int month2 = 0;
            while (month2 < 12) {
                Date workDate3 = DateUtil.getEndOfMonth(DateUtil.addOrRemoveMonths(startDate, month2));
                Float value2 = this.portfolio.getTracks().get("BEGIN_AUM").get(workDate3);
                if (value2 == null || this.portfolio.getTracks().get("MONTHLY_PERFORMANCE").get(workDate3) == null) {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
                } else {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(value2))));
                }
                ++month2;
            }
            this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
            this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph("Profit/Loss:")));
            float total = 0.0f;
            int month3 = 0;
            while (month3 < 12) {
                workDate = DateUtil.getEndOfMonth(DateUtil.addOrRemoveMonths(startDate, month3));
                value = this.portfolio.getTracks().get("PNL").get(workDate);
                Float fxValue = this.portfolio.getTracks().get("FX_PNL").get(workDate);
                if (value == null && fxValue == null) {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
                } else {
                    if (value == null) {
                        value = new Float(0.0);
                    }
                    if (fxValue == null) {
                        fxValue = new Float(0.0);
                    }
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)((Paragraph)new Paragraph(this.configuration.getAmountFormatter().format(value.floatValue() + fxValue.floatValue())).setBold()).setFontColor((double)(value.floatValue() + fxValue.floatValue()) < 0.0 ? this.configuration.getSequoiaRed() : this.configuration.getSequoiaGreen())));
                    total = total + value.floatValue() + fxValue.floatValue();
                }
                ++month3;
            }
            if (total != 0.0f) {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(total))));
            } else {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
            }
            this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph("Final Value:")));
            month3 = 0;
            while (month3 < 12) {
                workDate = DateUtil.getEndOfMonth(DateUtil.addOrRemoveMonths(startDate, month3));
                value = this.portfolio.getTracks().get("END_AUM").get(workDate);
                if (value == null) {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
                } else {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(value))));
                }
                ++month3;
            }
            this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
            this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph("Performance:")));
            total = 0.0f;
            month3 = 0;
            while (month3 < 12) {
                workDate = DateUtil.getEndOfMonth(DateUtil.addOrRemoveMonths(startDate, month3));
                value = this.portfolio.getTracks().get("MONTHLY_PERFORMANCE").get(workDate);
                if (value == null) {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
                } else {
                    this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)((Paragraph)new Paragraph(this.configuration.getPercentFormatter().format(value)).setBold()).setFontColor((double)value.floatValue() < 0.0 ? this.configuration.getSequoiaRed() : this.configuration.getSequoiaGreen())));
                    total += value.floatValue();
                }
                ++month3;
            }
            if (total != 0.0f) {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)((Paragraph)new Paragraph(this.configuration.getPercentFormatter().format(this.portfolio.getPerformance())).setBold()).setFontColor((double)this.portfolio.getPerformance() < 0.0 ? this.configuration.getSequoiaRed() : this.configuration.getSequoiaGreen())));
            } else {
                this.detailsTable.addHeaderCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
            }
            TimeSeriesCollection dataset = new TimeSeriesCollection();
            TimeSeries ts = new TimeSeries((Comparable)((Object)"Performance"));
            HashMap<Date, Float> track = this.portfolio.getTracks().get("DAILY_PERFORMANCE");
            Object[] allDates = track.keySet().toArray(new Date[0]);
            Arrays.sort(allDates);
            boolean first = true;
            double ratio = 100.0;
            Object[] objectArray = allDates;
            int n = allDates.length;
            int n2 = 0;
            while (n2 < n) {
                Object date = objectArray[n2];
                TimeSeriesDataItem item = null;
                if (first) {
                    ratio = 100.0 / (double)track.get(date).floatValue();
                    first = false;
                    item = new TimeSeriesDataItem((RegularTimePeriod)new Day((Date)date), 0.0);
                } else {
                    item = new TimeSeriesDataItem((RegularTimePeriod)new Day((Date)date), (ratio * (double)track.get(date).floatValue() - 100.0) / 100.0);
                }
                ts.add(item);
                ++n2;
            }
            Date effectiveEnd = DateUtil.addOrRemoveDays(DateUtil.addOneYear(this.report.getStartDate()), -1);
            dataset.addSeries(ts);
            JFreeChart chart = ChartFactory.createTimeSeriesChart((String)"", null, null, (XYDataset)dataset);
            chart.setBorderVisible(false);
            chart.setPadding(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
            chart.setAntiAlias(true);
            chart.removeLegend();
            XYPlot plot = (XYPlot)chart.getPlot();
            plot.getRendererForDataset(plot.getDataset(0)).setSeriesPaint(0, (Paint)this.configuration.getChartsColors()[0]);
            plot.setBackgroundPaint((Paint)this.configuration.getChartsColors()[9]);
            plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
            plot.setDomainGridlineStroke((Stroke)new BasicStroke(1.0f));
            plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
            plot.setOutlineVisible(false);
            plot.setAxisOffset(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
            NumberAxis valueAxis = (NumberAxis)plot.getRangeAxis();
            valueAxis.setNumberFormatOverride((NumberFormat)this.configuration.getPercentFormatter());
            DateAxis domainAxis = (DateAxis)plot.getDomainAxis();
            domainAxis.setDateFormatOverride((DateFormat)this.configuration.getDateFormatter());
            domainAxis.setTickUnit(new DateTickUnit(DateTickUnitType.MONTH, 1));
            domainAxis.setVisible(false);
            domainAxis.setAutoRange(false);
            domainAxis.setRange(this.report.getStartDate(), effectiveEnd);
            try {
                File dateChartFile = File.createTempFile(String.valueOf(this.portfolio.getName()) + "_", "-History.png", new File(this.configuration.getWorkingPath()));
                ChartUtilities.saveChartAsPNG((File)dateChartFile, (JFreeChart)chart, (int)1200, (int)360);
                Image chartImage = new Image(ImageDataFactory.create((String)dateChartFile.getCanonicalPath()));
                chartImage.scale(0.55f, 0.55f);
                this.detailsTable.addFooterCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add((BlockElement)noDataElement));
                this.detailsTable.addFooterCell(((Cell)new Cell(1, 13).setBorder(Border.NO_BORDER)).add(chartImage));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.detailsTable;
    }
}

