/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report.block;

import com.gso.finance.report.config.ReportsConfiguration;
import com.gso.finance.report.model.Portfolio;
import com.gso.finance.report.model.Position;
import com.itextpdf.kernel.color.Color;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.border.SolidBorder;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.TextAlignment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class SimplifiedPositionsDetails {
    private ReportsConfiguration configuration;
    private Portfolio portfolio;
    private String title;
    private ArrayList<Table> detailsTables = null;
    private Table detailsTable = null;

    public SimplifiedPositionsDetails(ReportsConfiguration configuration, Portfolio portfolio, String title) {
        this.configuration = configuration;
        this.portfolio = portfolio;
        this.title = title;
    }

    private void createPositionDetailsHeader() {
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Code")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Name")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Quantity")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Currency")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Buy price")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Current price")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Invested amount (security ccy)")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Invested amount (" + this.portfolio.getCurrency() + ")")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Weight")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Realized PnL")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Unrealized PnL")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Performance")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[4])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Total Contribution")));
    }

    public void createPositionDetailsData(Position position) {
        this.detailsTable.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(position.getCode())));
        this.detailsTable.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(position.getName())));
        this.detailsTable.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getPriceFormatter().format(position.getQuantity()))));
        this.detailsTable.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(position.getCurrency())));
        this.detailsTable.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getPriceFormatter().format(position.getBuyPrice()))));
        this.detailsTable.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getPriceFormatter().format(position.getPrice()))));
        this.detailsTable.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(position.getLocalCurrency()))));
        this.detailsTable.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(position.getPortfolio()))));
        this.detailsTable.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getPercentFormatter().format(position.getWeight()))));
        this.detailsTable.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getPriceFormatter().format(position.getRealizedPNL()))));
        this.detailsTable.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getPriceFormatter().format(position.getUnrealizedPNL()))));
        this.detailsTable.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getPercentFormatter().format(position.getUnrealizedPerformance()))));
        this.detailsTable.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getPercentFormatter().format(position.getContribution() + position.getFxContribution()))));
    }

    private void createSummaryTable(String title, ArrayList<String> keys, HashMap<String, Position> positions, Position totalPosition) {
        SolidBorder bigBorder = new SolidBorder(this.configuration.getSequoiaGreen(), 0.02f);
        this.detailsTable = new Table(new float[]{4.0f, 4.0f, 2.0f, 2.0f});
        this.detailsTable.setWidthPercent(100.0f);
        this.detailsTable.setTextAlignment(TextAlignment.CENTER);
        this.detailsTable.setFontSize(6.0f);
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, 4).setBorder(Border.NO_BORDER)).setBold()).setFontSize(8.0f)).setBackgroundColor(this.configuration.getSequoiaGreen())).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph(title)));
        this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell(1, 4).setBorder(Border.NO_BORDER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[2])).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Security type")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[2])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Invested amount (" + this.portfolio.getCurrency() + ")")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[2])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Weight")));
        this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setFontSize(6.0f)).setBold()).setBackgroundColor(this.configuration.getPdfColors()[2])).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("Global contribution")));
        for (String key : keys) {
            this.detailsTable.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(key)));
            this.detailsTable.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(positions.get(key).getPortfolio()))));
            this.detailsTable.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getPercentFormatter().format(positions.get(key).getWeight()))));
            this.detailsTable.addCell(((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setTextAlignment(TextAlignment.CENTER)).setFontColor(Color.BLACK)).add((BlockElement)new Paragraph(this.configuration.getPercentFormatter().format(positions.get(key).getGlobalContribution()))));
        }
        this.detailsTable.addCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBorderBottom((Border)bigBorder)).setBorderTop((Border)bigBorder)).setBold()).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.RIGHT)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph("")));
        this.detailsTable.addCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBorderBottom((Border)bigBorder)).setBorderTop((Border)bigBorder)).setBold()).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.CENTER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(totalPosition.getPortfolio()))));
        this.detailsTable.addCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBorderBottom((Border)bigBorder)).setBorderTop((Border)bigBorder)).setBold()).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.CENTER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.configuration.getPercentFormatter().format(totalPosition.getWeight()))));
        this.detailsTable.addCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBorderBottom((Border)bigBorder)).setBorderTop((Border)bigBorder)).setBold()).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.CENTER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.configuration.getPercentFormatter().format(totalPosition.getGlobalContribution()))));
    }

    public ArrayList<Table> getDetailsTables() {
        if (this.detailsTables == null) {
            this.detailsTables = new ArrayList();
            ArrayList<String> securityTypes = new ArrayList<String>();
            ArrayList<String> currencies = new ArrayList<String>();
            HashMap<String, Integer> counts = new HashMap<String, Integer>();
            Position[] positionArray = this.portfolio.getCurrentPositions();
            int n = positionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Position position = positionArray[n2];
                if (securityTypes.indexOf(position.getType()) == -1) {
                    securityTypes.add(position.getType());
                    counts.put(position.getType(), 0);
                }
                if (currencies.indexOf(position.getCurrency()) == -1) {
                    currencies.add(position.getCurrency());
                }
                counts.put(position.getType(), (Integer)counts.get(position.getType()) + 1);
                ++n2;
            }
            Collections.sort(securityTypes);
            Collections.sort(currencies);
            SolidBorder bigBorder = new SolidBorder(this.configuration.getSequoiaGreen(), 0.02f);
            Position totalAllTypes = new Position();
            HashMap<String, Position> typesSummary = new HashMap<String, Position>();
            HashMap<String, Position> currenciesSummary = new HashMap<String, Position>();
            Position[] positionsByWeight = this.portfolio.getPositionsByWeight();
            for (String securityType : securityTypes) {
                this.detailsTable = new Table(new float[]{2.5f, 4.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f});
                this.detailsTables.add(this.detailsTable);
                this.detailsTable.setWidthPercent(100.0f);
                this.detailsTable.setTextAlignment(TextAlignment.CENTER);
                this.detailsTable.setFontSize(6.0f);
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, 13).setBorder(Border.NO_BORDER)).setBold()).setFontSize(8.0f)).setBackgroundColor(this.configuration.getSequoiaGreen())).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph(String.valueOf(this.title) + " - DETAILS")));
                this.detailsTable.addHeaderCell(((Cell)((Cell)new Cell(1, 13).setBorder(Border.NO_BORDER)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph("")));
                String securityTypeTitle = "";
                securityTypeTitle = securityType.endsWith("y") ? securityType.subSequence(0, securityType.length() - 1) + "ies" : String.valueOf(securityType) + "s";
                this.detailsTable.addHeaderCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, 13).setBorder(Border.NO_BORDER)).setBold()).setFontSize(7.0f)).setBackgroundColor(this.configuration.getPdfColors()[2])).setTextAlignment(TextAlignment.LEFT)).setFontColor(Color.WHITE)).add((BlockElement)new Paragraph(securityTypeTitle)));
                this.createPositionDetailsHeader();
                Position totalPerType = new Position();
                Position[] positionArray2 = positionsByWeight;
                int n3 = positionsByWeight.length;
                int n4 = 0;
                while (n4 < n3) {
                    Position position = positionArray2[n4];
                    if (position.getType().equals(securityType)) {
                        this.createPositionDetailsData(position);
                        totalPerType.setWeight(position.getWeight() + totalPerType.getWeight());
                        totalPerType.setPortfolio(position.getPortfolio() + totalPerType.getPortfolio());
                        totalPerType.setContribution(position.getContribution() + totalPerType.getContribution());
                        totalPerType.setFxContribution(position.getFxContribution() + totalPerType.getFxContribution());
                        totalPerType.setGlobalContribution(position.getGlobalContribution() + totalPerType.getGlobalContribution());
                        if (currenciesSummary.get(position.getCurrency()) == null) {
                            currenciesSummary.put(position.getCurrency(), new Position());
                        }
                        Position currencyPosition = currenciesSummary.get(position.getCurrency());
                        currencyPosition.setWeight(position.getWeight() + currencyPosition.getWeight());
                        currencyPosition.setPortfolio(position.getPortfolio() + currencyPosition.getPortfolio());
                        currencyPosition.setContribution(position.getContribution() + currencyPosition.getContribution());
                        currencyPosition.setFxContribution(position.getFxContribution() + currencyPosition.getFxContribution());
                        currencyPosition.setGlobalContribution(position.getGlobalContribution() + currencyPosition.getGlobalContribution());
                    }
                    ++n4;
                }
                this.detailsTable.addCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, 7).setBorder(Border.NO_BORDER)).setBorderBottom((Border)bigBorder)).setBorderTop((Border)bigBorder)).setBold()).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.CENTER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph("")));
                this.detailsTable.addCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBorderBottom((Border)bigBorder)).setBorderTop((Border)bigBorder)).setBold()).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.CENTER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.configuration.getAmountFormatter().format(totalPerType.getPortfolio()))));
                this.detailsTable.addCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBorderBottom((Border)bigBorder)).setBorderTop((Border)bigBorder)).setBold()).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.CENTER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.configuration.getPercentFormatter().format(totalPerType.getWeight()))));
                this.detailsTable.addCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell(1, 3).setBorder(Border.NO_BORDER)).setBorderBottom((Border)bigBorder)).setBorderTop((Border)bigBorder)).setBold()).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.CENTER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph("")));
                this.detailsTable.addCell(((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)((Cell)new Cell().setBorder(Border.NO_BORDER)).setBorderBottom((Border)bigBorder)).setBorderTop((Border)bigBorder)).setBold()).setFontSize(7.0f)).setBackgroundColor(Color.WHITE)).setTextAlignment(TextAlignment.CENTER)).setFontColor(this.configuration.getSequoiaGreen())).add((BlockElement)new Paragraph(this.configuration.getPercentFormatter().format(totalPerType.getGlobalContribution()))));
                typesSummary.put(securityType, totalPerType);
                totalAllTypes.setWeight(totalAllTypes.getWeight() + totalPerType.getWeight());
                totalAllTypes.setPortfolio(totalAllTypes.getPortfolio() + totalPerType.getPortfolio());
                totalAllTypes.setContribution(totalAllTypes.getContribution() + totalPerType.getContribution());
                totalAllTypes.setFxContribution(totalAllTypes.getFxContribution() + totalPerType.getFxContribution());
                totalAllTypes.setGlobalContribution(totalAllTypes.getGlobalContribution() + totalPerType.getGlobalContribution());
            }
            Table summaryTable = new Table(new float[]{10.0f, 10.0f});
            summaryTable.setWidthPercent(100.0f);
            this.createSummaryTable(String.valueOf(this.title) + " - Summary by security types", securityTypes, typesSummary, totalAllTypes);
            summaryTable.addCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add(this.detailsTable));
            this.createSummaryTable(String.valueOf(this.title) + " - Summary by currencies", currencies, currenciesSummary, totalAllTypes);
            summaryTable.addCell(((Cell)new Cell().setBorder(Border.NO_BORDER)).add(this.detailsTable));
            this.detailsTables.add(0, summaryTable);
        }
        return this.detailsTables;
    }
}

