/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.gso.finance.report.model.AssetValue;
import com.gso.finance.report.model.MovementDetails;
import java.util.ArrayList;

public class Account {
    private String name;
    private String code;
    private String currency;
    private String bank;
    private String type;
    private AssetValue beginningAssets;
    private AssetValue endAssets;
    private AssetValue movements;
    private AssetValue pnl;
    private MovementDetails movementsDetails;

    public Account() {
    }

    public Account(JsonNode node) {
        this.name = node.get("name").asText();
        this.code = node.get("code").asText();
        this.currency = node.get("currency").asText();
        this.type = node.get("type").asText();
        this.bank = node.get("bank").asText();
        this.beginningAssets = new AssetValue();
        this.endAssets = new AssetValue();
        if (node.has("assets")) {
            this.beginningAssets.localCurrency = new Float(node.get("assets").get("start").get("account").asDouble()).floatValue();
            this.beginningAssets.portfolioCurrency = new Float(node.get("assets").get("start").get("portfolio").asDouble()).floatValue();
            this.beginningAssets.spot = new Float(node.get("assets").get("start").get("spot").asDouble()).floatValue();
            this.endAssets.localCurrency = new Float(node.get("assets").get("end").get("account").asDouble()).floatValue();
            this.endAssets.portfolioCurrency = new Float(node.get("assets").get("end").get("portfolio").asDouble()).floatValue();
            this.endAssets.spot = new Float(node.get("assets").get("end").get("spot").asDouble()).floatValue();
        } else {
            this.beginningAssets.localCurrency = 0.0f;
            this.beginningAssets.portfolioCurrency = 0.0f;
            this.beginningAssets.spot = Float.NaN;
            this.endAssets.localCurrency = 0.0f;
            this.endAssets.portfolioCurrency = 0.0f;
            this.endAssets.spot = Float.NaN;
        }
        this.movementsDetails = new MovementDetails(node.get("all_movements"));
        this.movements = new AssetValue();
        if (node.has("movements")) {
            this.movements.localCurrency = new Float(node.get("movements").get("account").asDouble()).floatValue();
            this.movements.portfolioCurrency = new Float(node.get("movements").get("portfolio").asDouble()).floatValue();
            this.movements.spot = Float.NaN;
        } else {
            this.movements.localCurrency = Float.NaN;
            this.movements.portfolioCurrency = Float.NaN;
            this.movements.spot = Float.NaN;
        }
        this.pnl = new AssetValue();
        if (node.has("movements")) {
            this.pnl.localCurrency = new Float(node.get("pnl").get("account").asDouble()).floatValue();
            this.pnl.portfolioCurrency = new Float(node.get("pnl").get("portfolio").asDouble()).floatValue();
            this.pnl.spot = Float.NaN;
        } else {
            this.pnl.localCurrency = Float.NaN;
            this.pnl.portfolioCurrency = Float.NaN;
            this.pnl.spot = Float.NaN;
        }
    }

    public static Account[] fromJsonNode(JsonNode node) {
        ArrayList<Account> accounts = new ArrayList<Account>();
        for (JsonNode element : node) {
            accounts.add(new Account(element));
        }
        return accounts.toArray(new Account[0]);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public AssetValue getBeginningAssets() {
        return this.beginningAssets;
    }

    public void setBeginningAssets(AssetValue beginningAssets) {
        this.beginningAssets = beginningAssets;
    }

    public AssetValue getEndAssets() {
        return this.endAssets;
    }

    public void setEndAssets(AssetValue endAssets) {
        this.endAssets = endAssets;
    }

    public AssetValue getMovements() {
        return this.movements;
    }

    public void setMovements(AssetValue movements) {
        this.movements = movements;
    }

    public AssetValue getPnl() {
        return this.pnl;
    }

    public void setPnl(AssetValue pnl) {
        this.pnl = pnl;
    }

    public String getBank() {
        return this.bank;
    }

    public void setBank(String bank) {
        this.bank = bank;
    }

    public MovementDetails getMovementsDetails() {
        return this.movementsDetails;
    }

    public void setMovementsDetails(MovementDetails movementsDetails) {
        this.movementsDetails = movementsDetails;
    }
}

