/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report.model;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Random;

public class Breakdown
implements Comparable<Breakdown> {
    public String name;
    public float value;
    public float weight;

    public Breakdown() {
    }

    public Breakdown(JsonNode node) {
        this.name = node.get("key").asText();
        this.value = new Float(node.get("assets_pf").asDouble()).floatValue();
        this.weight = new Float(node.get("weight").asDouble() / 100.0).floatValue();
    }

    @Override
    public int compareTo(Breakdown bd) {
        return new Float((bd.weight - this.weight) * 10000.0f).intValue();
    }

    public static Breakdown[] getSample(int length) {
        ArrayList<Breakdown> breakdowns = new ArrayList<Breakdown>();
        Random random = new Random();
        float total = 0.0f;
        int index = 0;
        while (index < length) {
            Breakdown bd = new Breakdown();
            bd.name = "VALUE " + index;
            bd.value = random.nextFloat() * 1000000.0f;
            breakdowns.add(bd);
            total += bd.value;
            ++index;
        }
        for (Breakdown bd : breakdowns) {
            bd.weight = bd.value / total;
        }
        return breakdowns.toArray(new Breakdown[0]);
    }

    public static Breakdown[] fromJsonNode(JsonNode node) {
        ArrayList<Breakdown> bd = new ArrayList<Breakdown>();
        if (node != null) {
            for (JsonNode element : node) {
                bd.add(new Breakdown(element));
            }
        }
        return bd.toArray(new Breakdown[0]);
    }
}

