/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class Company
implements Serializable {
    private static final long serialVersionUID = -568003265340844978L;
    private String name;
    private String currency;
    private String currencyCode;
    private String street;
    private String city;
    private String zipCode;
    private String country;
    private String countryCode;
    private String phoneNumber;
    private String faxNumber;
    private String webSite;
    private String email;

    public Company() {
    }

    public Company(File jsonFile) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(jsonFile);
            this.name = node.get("name").asText();
            this.currency = node.has("currency") ? node.get("currency").asText() : "N/A";
            this.setCurrencyCode(node.get("currencyCode").asText());
            if (node.has("addresses")) {
                for (JsonNode address : node.get("addresses")) {
                    if (address.get("address_type").get("identifier").asText().equals("ADR_MAIN_OFFICE")) {
                        this.street = address.get("line_1").asText();
                        if (address.has("line_2") && !address.get("line_2").asText().equals("")) {
                            this.street = String.valueOf(this.street) + " " + address.get("line_2");
                        }
                        this.city = address.get("city").asText();
                        this.zipCode = address.get("zip_code").asText();
                        this.country = address.get("country").get("name").asText();
                        this.countryCode = address.get("country").get("short_name").asText();
                    }
                    if (!address.get("address_type").get("identifier").asText().equals("ADR_WEB")) continue;
                    this.webSite = address.get("line_1").asText();
                }
            }
            if (node.has("emails")) {
                for (JsonNode emailNode : node.get("emails")) {
                    if (!emailNode.get("address_type").get("identifier").asText().equals("EMAIL_CONTACT")) continue;
                    this.setEmail(emailNode.get("email_address").asText());
                }
            }
            if (node.has("phones")) {
                for (JsonNode phoneNode : node.get("phones")) {
                    if (phoneNode.get("line_type").get("identifier").asText().equals("PHONE_LAND_CONTACT")) {
                        this.phoneNumber = phoneNode.get("phone_number").asText();
                    }
                    if (!phoneNode.get("line_type").get("identifier").asText().equals("PHONE_FAX_WORK")) continue;
                    this.faxNumber = phoneNode.get("phone_number").asText();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Company(JsonNode node) {
        this.name = node.get("name").asText();
        this.currency = node.has("currency") ? node.get("currency").asText() : "N/A";
        this.setCurrencyCode(node.get("currencyCode").asText());
        if (node.has("addresses")) {
            for (JsonNode address : node.get("addresses")) {
                if (address.get("address_type").get("identifier").asText().equals("ADR_MAIN_OFFICE")) {
                    this.street = address.get("line_1").asText();
                    if (address.has("line_2") && !address.get("line_2").asText().equals("")) {
                        this.street = String.valueOf(this.street) + " " + address.get("line_2");
                    }
                    this.city = address.get("city").asText();
                    this.zipCode = address.get("zip_code").asText();
                    this.country = address.get("country").get("name").asText();
                    this.countryCode = address.get("country").get("short_name").asText();
                }
                if (!address.get("address_type").get("identifier").asText().equals("ADR_WEB")) continue;
                this.webSite = address.get("line_1").asText();
            }
        }
        if (node.has("emails")) {
            for (JsonNode emailNode : node.get("emails")) {
                if (!emailNode.get("address_type").get("identifier").asText().equals("EMAIL_CONTACT")) continue;
                this.setEmail(emailNode.get("email_address").asText());
            }
        }
        if (node.has("phones")) {
            for (JsonNode phoneNode : node.get("phones")) {
                if (phoneNode.get("line_type").get("identifier").asText().equals("PHONE_LAND_CONTACT")) {
                    this.phoneNumber = phoneNode.get("phone_number").asText();
                }
                if (!phoneNode.get("line_type").get("identifier").asText().equals("PHONE_FAX_WORK")) continue;
                this.faxNumber = phoneNode.get("phone_number").asText();
            }
        }
    }

    public String getSignatureAddress() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getStreet());
        sb.append(" | ");
        sb.append(this.getZipCode());
        sb.append(" ");
        sb.append(this.getCity());
        sb.append(" | ");
        sb.append(this.getCountry());
        sb.append(" | ");
        sb.append("T ");
        sb.append(this.getPhoneNumber());
        sb.append(" | ");
        sb.append("F ");
        sb.append(this.getFaxNumber());
        sb.append(" | ");
        sb.append(this.getWebSite().replaceAll("http://", "").replaceAll("https://", ""));
        return sb.toString();
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getFaxNumber() {
        return this.faxNumber;
    }

    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }

    public String getWebSite() {
        return this.webSite;
    }

    public void setWebSite(String webSite) {
        this.webSite = webSite;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }
}

