/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report.model;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;

public class ConstraintResult
implements Serializable {
    private static final long serialVersionUID = 6300448445377269694L;
    private boolean constraintBroken;
    private String name = "";
    private String message = "";
    private double value = 0.0;
    private double minimum = 0.0;
    private double maximum = 0.0;

    public ConstraintResult(JsonNode node) {
        this.constraintBroken = node.get("constraint_result").asBoolean();
        this.message = node.get("message").asText();
        this.value = node.get("value").asDouble() / 100.0;
        this.name = node.get("name").asText();
        this.minimum = node.get("expected_minimum").asDouble() / 100.0;
        this.maximum = node.get("expected_maximum").asDouble() / 100.0;
    }

    public boolean isConstraintBroken() {
        return this.constraintBroken;
    }

    public void setConstraintBroken(boolean constraintBroken) {
        this.constraintBroken = constraintBroken;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(double minimum) {
        this.minimum = minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(double maximum) {
        this.maximum = maximum;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

