/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gso.finance.report.model.ConstraintResult;
import com.gso.finance.report.model.Portfolio;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class ConstraintsResults {
    private Portfolio portfolio = null;
    private ArrayList<ConstraintResult> results = new ArrayList();

    public ConstraintsResults(File jsonFile) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(jsonFile);
            for (JsonNode result : node.get("results")) {
                if (this.portfolio != null) continue;
                this.portfolio = new Portfolio(result.get("container"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ConstraintsResults(JsonNode node) {
        this.portfolio = new Portfolio(node.get("container"));
        Iterator elements = node.get("results").elements();
        while (elements.hasNext()) {
            JsonNode result = (JsonNode)elements.next();
            this.results.add(new ConstraintResult(result));
        }
    }

    public Portfolio getPortfolio() {
        return this.portfolio;
    }

    public void setPortfolio(Portfolio portfolio) {
        this.portfolio = portfolio;
    }

    public ArrayList<ConstraintResult> getResults() {
        return this.results;
    }

    public void setResults(ArrayList<ConstraintResult> results) {
        this.results = results;
    }

    public static ConstraintsResults[] fromJsonNode(JsonNode node) {
        ArrayList<ConstraintsResults> crs = new ArrayList<ConstraintsResults>();
        for (JsonNode element : node) {
            crs.add(new ConstraintsResults(element));
        }
        return crs.toArray(new ConstraintsResults[0]);
    }
}

