/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gso.finance.report.model.Account;
import com.gso.finance.report.model.Position;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class Operation
implements Serializable {
    private static final long serialVersionUID = -738498410163257237L;
    public static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    public static SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Long id;
    private String name;
    private String description;
    private String amlStatus;
    private String orderType;
    private String orderDuration;
    private Date inputDate;
    private Date executionDate;
    private Date limitDate;
    private float limitPrice = 0.0f;
    private float stopPrice = 0.0f;
    private Date sentDate;
    private Date cancelDate;
    private String operationStatus;
    private String operationType;
    private String operationTypeCode;
    private String operator;
    private String validator;
    private Account sourceAccount;
    private Account targetAccount;
    private Position targetPosition;
    private float quantity = 0.0f;
    private float spotRate = 1.0f;
    private float amount = 0.0f;
    private float price = 0.0f;
    private float billing = 0.0f;
    private Date operationDate;
    private Date valueDate;
    private Date terminationDate;
    private Long[] documents;
    private boolean amlBreached = false;
    private String amlReason;
    private float amountManagement = 0.0f;

    public Operation() {
    }

    public Operation(File jsonFile) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(jsonFile);
            this.id = node.get("internalId").asLong();
            this.name = node.get("name").asText();
            this.description = node.get("description").asText();
            this.amlStatus = node.get("amlStatus").asText();
            this.orderType = node.get("orderType").asText();
            this.orderDuration = node.get("orderDuration").asText();
            this.inputDate = !node.get("inputDate").isNull() ? dateTimeFormatter.parse(node.get("inputDate").asText()) : null;
            this.executionDate = !node.get("executionDate").isNull() ? dateTimeFormatter.parse(node.get("executionDate").asText()) : null;
            this.limitDate = !node.get("limitDate").isNull() ? dateFormatter.parse(node.get("limitDate").asText()) : null;
            this.limitPrice = !node.get("limitPrice").isNull() ? new Double(node.get("limitPrice").asDouble()).floatValue() : 0.0f;
            this.stopPrice = !node.get("stopPrice").isNull() ? new Double(node.get("stopPrice").asDouble()).floatValue() : 0.0f;
            this.sentDate = !node.get("sentDate").isNull() ? dateTimeFormatter.parse(node.get("sentDate").asText()) : null;
            this.cancelDate = !node.get("cancelDate").isNull() ? dateTimeFormatter.parse(node.get("cancelDate").asText()) : null;
            this.operationStatus = node.get("operationStatus").asText();
            this.operationType = node.get("operationType").asText();
            this.operationTypeCode = node.has("operationTypeCode") ? node.get("operationTypeCode").asText() : null;
            this.billing = node.get("billing").isNull() ? new Double(node.get("billing").asDouble()).floatValue() : 0.0f;
            this.amlBreached = node.get("amlBreached").asBoolean();
            this.amlReason = node.get("amlReason").asText();
            this.operator = node.get("operator").asText();
            this.validator = node.get("validator").asText();
            if (node.has("sourceAccount")) {
                this.sourceAccount = new Account(node.get("sourceAccount"));
            }
            if (node.has("targetAccount")) {
                this.targetAccount = new Account(node.get("targetAccount"));
            }
            if (node.has("targetPosition")) {
                this.targetPosition = new Position(node.get("targetPosition"));
            }
            this.quantity = new Double(node.get("quantity").asDouble()).floatValue();
            this.spotRate = new Double(node.get("spotRate").asDouble()).floatValue();
            this.amount = new Double(node.get("amount").asDouble()).floatValue();
            this.setAmountManagement(new Double(node.get("amountMgmt").asDouble()).floatValue());
            this.price = new Double(node.get("price").asDouble()).floatValue();
            this.operationDate = dateFormatter.parse(node.get("operationDate").asText());
            this.valueDate = dateFormatter.parse(node.get("valueDate").asText());
            if (this.inputDate == null) {
                this.inputDate = this.operationDate;
            }
            if (this.executionDate == null) {
                this.executionDate = this.valueDate;
            }
            this.terminationDate = dateFormatter.parse(node.get("terminationDate").asText());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public Operation(JsonNode node) {
        try {
            this.id = node.get("internalId").asLong();
            this.name = node.get("name").asText();
            this.description = node.get("description").asText();
            this.amlStatus = node.get("amlStatus").asText();
            this.orderType = node.get("orderType").asText();
            this.orderDuration = node.get("orderDuration").asText();
            this.inputDate = !node.get("inputDate").isNull() ? dateTimeFormatter.parse(node.get("inputDate").asText()) : null;
            this.executionDate = !node.get("executionDate").isNull() ? dateTimeFormatter.parse(node.get("executionDate").asText()) : null;
            this.limitDate = !node.get("limitDate").isNull() ? dateFormatter.parse(node.get("limitDate").asText()) : null;
            this.limitPrice = !node.get("limitPrice").isNull() ? new Double(node.get("limitPrice").asDouble()).floatValue() : 0.0f;
            this.stopPrice = !node.get("stopPrice").isNull() ? new Double(node.get("stopPrice").asDouble()).floatValue() : 0.0f;
            this.sentDate = !node.get("sentDate").isNull() ? dateTimeFormatter.parse(node.get("sentDate").asText()) : null;
            this.cancelDate = !node.get("cancelDate").isNull() ? dateTimeFormatter.parse(node.get("cancelDate").asText()) : null;
            this.operationStatus = node.get("operationStatus").asText();
            this.operationType = node.get("operationType").asText();
            this.operationTypeCode = node.has("operationTypeCode") ? node.get("operationTypeCode").asText() : null;
            this.operator = node.get("operator").asText();
            this.validator = node.get("validator").asText();
            if (node.has("sourceAccount")) {
                this.sourceAccount = new Account(node.get("sourceAccount"));
            }
            if (node.has("targetAccount")) {
                this.targetAccount = new Account(node.get("targetAccount"));
            }
            if (node.has("targetPosition")) {
                this.targetPosition = new Position(node.get("targetPosition"));
            }
            this.quantity = new Double(node.get("quantity").asDouble()).floatValue();
            this.spotRate = new Double(node.get("spotRate").asDouble()).floatValue();
            this.amount = new Double(node.get("amount").asDouble()).floatValue();
            this.price = new Double(node.get("price").asDouble()).floatValue();
            this.billing = !node.get("billing").isNull() ? new Double(node.get("billing").asDouble()).floatValue() : 0.0f;
            this.setAmountManagement(new Double(node.get("amountMgmt").asDouble()).floatValue());
            this.amlBreached = node.get("amlBreached").asBoolean();
            this.amlReason = node.get("amlReason").asText();
            ArrayList<Long> documents = new ArrayList<Long>();
            for (JsonNode dNode : node.get("documents")) {
                documents.add(dNode.asLong());
            }
            this.documents = documents.toArray(new Long[0]);
            this.operationDate = dateFormatter.parse(node.get("operationDate").asText());
            this.valueDate = dateFormatter.parse(node.get("valueDate").asText());
            this.terminationDate = dateFormatter.parse(node.get("terminationDate").asText());
            if (this.inputDate == null) {
                this.inputDate = this.operationDate;
            }
            if (this.executionDate == null) {
                this.executionDate = this.valueDate;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static Operation[] fromJsonNode(JsonNode node) {
        ArrayList<Operation> ops = new ArrayList<Operation>();
        if (node != null) {
            for (JsonNode element : node) {
                ops.add(new Operation(element));
            }
        }
        return ops.toArray(new Operation[0]);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAmlStatus() {
        return this.amlStatus;
    }

    public void setAmlStatus(String amlStatus) {
        this.amlStatus = amlStatus;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public Date getInputDate() {
        return this.inputDate;
    }

    public void setInputDate(Date inputDate) {
        this.inputDate = inputDate;
    }

    public Date getExecutionDate() {
        return this.executionDate;
    }

    public void setExecutionDate(Date executionDate) {
        this.executionDate = executionDate;
    }

    public Date getLimitDate() {
        return this.limitDate;
    }

    public void setLimitDate(Date limitDate) {
        this.limitDate = limitDate;
    }

    public float getLimitPrice() {
        return this.limitPrice;
    }

    public void setLimitPrice(float limitPrice) {
        this.limitPrice = limitPrice;
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    public String getOrderDuration() {
        return this.orderDuration;
    }

    public void setOrderDuration(String orderDuration) {
        this.orderDuration = orderDuration;
    }

    public String getOperationStatus() {
        return this.operationStatus;
    }

    public void setOperationStatus(String operationStatus) {
        this.operationStatus = operationStatus;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getValidator() {
        return this.validator;
    }

    public void setValidator(String validator) {
        this.validator = validator;
    }

    public Account getSourceAccount() {
        return this.sourceAccount;
    }

    public void setSourceAccount(Account sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    public Account getTargetAccount() {
        return this.targetAccount;
    }

    public void setTargetAccount(Account targetAccount) {
        this.targetAccount = targetAccount;
    }

    public Position getTargetPosition() {
        return this.targetPosition;
    }

    public void setTargetPosition(Position targetPosition) {
        this.targetPosition = targetPosition;
    }

    public float getQuantity() {
        return this.quantity;
    }

    public void setQuantity(float quantity) {
        this.quantity = quantity;
    }

    public float getSpotRate() {
        return this.spotRate;
    }

    public void setSpotRate(float spotRate) {
        this.spotRate = spotRate;
    }

    public float getStopPrice() {
        return this.stopPrice;
    }

    public void setStopPrice(float stopPrice) {
        this.stopPrice = stopPrice;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setAmount(float amount) {
        this.amount = amount;
    }

    public float getPrice() {
        return this.price;
    }

    public void setPrice(float price) {
        this.price = price;
    }

    public Date getOperationDate() {
        return this.operationDate;
    }

    public void setOperationDate(Date operationDate) {
        this.operationDate = operationDate;
    }

    public Date getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(Date valueDate) {
        this.valueDate = valueDate;
    }

    public Date getTerminationDate() {
        return this.terminationDate;
    }

    public void setTerminationDate(Date terminationDate) {
        this.terminationDate = terminationDate;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getCancelDate() {
        return this.cancelDate;
    }

    public void setCancelDate(Date cancelDate) {
        this.cancelDate = cancelDate;
    }

    public float getBilling() {
        return this.billing;
    }

    public void setBilling(float billing) {
        this.billing = billing;
    }

    public boolean isAmlBreached() {
        return this.amlBreached;
    }

    public void setAmlBreached(boolean amlBreached) {
        this.amlBreached = amlBreached;
    }

    public String getAmlReason() {
        return this.amlReason;
    }

    public void setAmlReason(String amlReason) {
        this.amlReason = amlReason;
    }

    public Long[] getDocuments() {
        return this.documents;
    }

    public void setDocuments(Long[] documents) {
        this.documents = documents;
    }

    public float getAmountManagement() {
        return this.amountManagement;
    }

    public void setAmountManagement(float amountManagement) {
        this.amountManagement = amountManagement;
    }

    public String getOperationTypeCode() {
        return this.operationTypeCode;
    }

    public void setOperationTypeCode(String operationTypeCode) {
        this.operationTypeCode = operationTypeCode;
    }
}

