/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gso.finance.report.model.Account;
import com.gso.finance.report.model.Breakdown;
import com.gso.finance.report.model.Company;
import com.gso.finance.report.model.MovementDetails;
import com.gso.finance.report.model.Position;
import com.gso.finance.report.model.ThirdParty;
import com.gso.finance.report.utility.NodeUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class Portfolio
implements Serializable {
    private static final long serialVersionUID = 5028348138347918562L;
    public static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private String name;
    private String code;
    private String currency;
    private String bank;
    private String style;
    private String mandate;
    private ThirdParty[] contacts = new ThirdParty[0];
    private Date inceptionDate;
    private Date startDate;
    private Date workingDate;
    private boolean targetVAT = false;
    private float vatRate = 0.0f;
    private float startAUM = 0.0f;
    private float endAUM = 0.0f;
    private float averageInvestedAUM = 0.0f;
    private float movements = 0.0f;
    private ThirdParty relationshipManager = null;
    private float pnl = 0.0f;
    private float fxPnl = 0.0f;
    private float performance = 0.0f;
    private Company managementCompany = null;
    private HashMap<String, HashMap<Date, Float>> tracks = new HashMap();
    private HashMap<Date, MovementDetails> movementsDetails = new HashMap();
    private Breakdown[] securityTypeBreakdown = new Breakdown[0];
    private Breakdown[] currencyBreakdown = new Breakdown[0];
    private Account[] accounts = new Account[0];
    private Position[] currentPositions = new Position[0];
    private Position[] soldPositions = new Position[0];
    private Portfolio[] subPortfolios = new Portfolio[0];

    public Portfolio() {
    }

    public Portfolio(File jsonFile) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(jsonFile);
            this.name = node.get("name").asText();
            this.code = node.get("code").asText();
            this.currency = node.get("currency").asText();
            this.bank = node.get("bank").asText();
            this.style = node.get("style").asText();
            this.setMandate(node.get("mandate").asText());
            this.startAUM = new Double(node.get("startAUM").asDouble()).floatValue();
            this.endAUM = new Double(node.get("endAUM").asDouble()).floatValue();
            this.averageInvestedAUM = new Double(node.get("averageInvestedAUM").asDouble()).floatValue();
            this.movements = new Double(node.get("movements").asDouble()).floatValue();
            this.pnl = new Double(node.get("pnl").asDouble()).floatValue();
            this.fxPnl = new Double(node.get("fxPnl").asDouble()).floatValue();
            this.targetVAT = node.get("targetVAT").asBoolean();
            this.vatRate = new Double(node.get("vatRate").asDouble()).floatValue();
            this.performance = new Double(node.get("performance").asDouble()).floatValue();
            Company company = this.managementCompany = node.has("managementCompany") ? new Company(node.get("managementCompany")) : null;
            if (node.has("relationshipManager")) {
                this.relationshipManager = new ThirdParty(node.get("relationshipManager"));
            }
            this.inceptionDate = dateFormatter.parse(node.get("inceptionDate").asText());
            this.startDate = dateFormatter.parse(node.get("startDate").asText());
            this.workingDate = dateFormatter.parse(node.get("workingDate").asText());
            this.movementsDetails = NodeUtil.movementsTrackFromNode(node.get("tracks").get("MOVEMENTS"));
            this.tracks.put("BEGIN_AUM", NodeUtil.trackFromNode(node.get("tracks").get("BEGIN_AUM")));
            this.tracks.put("END_AUM", NodeUtil.trackFromNode(node.get("tracks").get("END_AUM")));
            this.tracks.put("PNL", NodeUtil.trackFromNode(node.get("tracks").get("PNL")));
            this.tracks.put("FX_PNL", NodeUtil.trackFromNode(node.get("tracks").get("FX_PNL")));
            this.tracks.put("MONTHLY_PERFORMANCE", NodeUtil.trackFromNode(node.get("tracks").get("MONTHLY_PERFORMANCE")));
            this.tracks.put("DAILY_PERFORMANCE", NodeUtil.trackFromNode(node.get("tracks").get("DAILY_PERFORMANCE")));
            this.securityTypeBreakdown = Breakdown.fromJsonNode(node.get("securityTypeBreakdown"));
            this.currencyBreakdown = Breakdown.fromJsonNode(node.get("currencyBreakdown"));
            this.contacts = ThirdParty.fromJsonNode(node.get("contacts"));
            this.accounts = Account.fromJsonNode(node.get("accounts"));
            this.currentPositions = Position.fromJsonNode(node.get("positions").get("current"));
            this.soldPositions = Position.fromJsonNode(node.get("positions").get("sold"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public Portfolio(JsonNode node) {
        try {
            this.name = node.get("name").asText();
            this.code = node.get("code").asText();
            this.currency = node.get("currency").asText();
            this.bank = node.get("bank").asText();
            this.style = node.get("style").asText();
            this.setMandate(node.get("mandate").asText());
            if (node.has("startAUM")) {
                this.startAUM = new Double(node.get("startAUM").asDouble()).floatValue();
            }
            if (node.has("endAUM")) {
                this.endAUM = new Double(node.get("endAUM").asDouble()).floatValue();
            }
            if (node.has("averageInvestedAUM")) {
                this.averageInvestedAUM = new Double(node.get("averageInvestedAUM").asDouble()).floatValue();
            }
            if (node.has("averageInvestedAUM")) {
                this.movements = new Double(node.get("averageInvestedAUM").asDouble()).floatValue();
            }
            if (node.has("pnl")) {
                this.pnl = new Double(node.get("pnl").asDouble()).floatValue();
            }
            if (node.has("fxPnl")) {
                this.fxPnl = new Double(node.get("fxPnl").asDouble()).floatValue();
            }
            if (node.has("targetVAT")) {
                this.targetVAT = node.get("targetVAT").asBoolean();
                this.vatRate = new Double(node.get("vatRate").asDouble()).floatValue();
            }
            if (node.has("performance")) {
                this.performance = new Double(node.get("performance").asDouble()).floatValue();
            }
            Company company = this.managementCompany = node.has("managementCompany") ? new Company(node.get("managementCompany")) : null;
            if (node.has("relationshipManager")) {
                this.relationshipManager = new ThirdParty(node.get("relationshipManager"));
            }
            this.inceptionDate = dateFormatter.parse(node.get("inceptionDate").asText());
            if (node.has("startDate")) {
                this.startDate = dateFormatter.parse(node.get("startDate").asText());
            }
            if (node.has("workingDate")) {
                this.workingDate = dateFormatter.parse(node.get("workingDate").asText());
            }
            if (node.has("tracks")) {
                try {
                    this.movementsDetails = NodeUtil.movementsTrackFromNode(node.get("tracks").get("MOVEMENTS"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.tracks.put("BEGIN_AUM", NodeUtil.trackFromNode(node.get("tracks").get("BEGIN_AUM")));
                this.tracks.put("END_AUM", NodeUtil.trackFromNode(node.get("tracks").get("END_AUM")));
                this.tracks.put("PNL", NodeUtil.trackFromNode(node.get("tracks").get("PNL")));
                this.tracks.put("FX_PNL", NodeUtil.trackFromNode(node.get("tracks").get("FX_PNL")));
                this.tracks.put("MONTHLY_PERFORMANCE", NodeUtil.trackFromNode(node.get("tracks").get("MONTHLY_PERFORMANCE")));
                this.tracks.put("DAILY_PERFORMANCE", NodeUtil.trackFromNode(node.get("tracks").get("DAILY_PERFORMANCE")));
            }
            this.securityTypeBreakdown = Breakdown.fromJsonNode(node.get("securityTypeBreakdown"));
            this.currencyBreakdown = Breakdown.fromJsonNode(node.get("currencyBreakdown"));
            this.contacts = ThirdParty.fromJsonNode(node.get("contacts"));
            if (node.has("accounts")) {
                this.accounts = Account.fromJsonNode(node.get("accounts"));
            }
            if (node.has("positions")) {
                this.currentPositions = Position.fromJsonNode(node.get("positions").get("current"));
                this.soldPositions = Position.fromJsonNode(node.get("positions").get("sold"));
            }
            ArrayList<Portfolio> sPfList = new ArrayList<Portfolio>();
            if (node.has("sub_portfolios")) {
                JsonNode subNodes = node.get("sub_portfolios");
                Iterator elements = subNodes.elements();
                while (elements.hasNext()) {
                    Portfolio sPf = new Portfolio((JsonNode)elements.next());
                    sPfList.add(sPf);
                }
                if (sPfList.size() > 0) {
                    this.subPortfolios = sPfList.toArray(new Portfolio[0]);
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getBank() {
        return this.bank;
    }

    public void setBank(String bank) {
        this.bank = bank;
    }

    public Date getWorkingDate() {
        return this.workingDate;
    }

    public void setWorkingDate(Date workingDate) {
        this.workingDate = workingDate;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean isTargetVAT() {
        return this.targetVAT;
    }

    public void setTargetVAT(boolean targetVAT) {
        this.targetVAT = targetVAT;
    }

    public float getVatRate() {
        return this.vatRate;
    }

    public void setVatRate(float vatRate) {
        this.vatRate = vatRate;
    }

    public Date getInceptionDate() {
        return this.inceptionDate;
    }

    public void setInceptionDate(Date inceptionDate) {
        this.inceptionDate = inceptionDate;
    }

    public Date getStartDate() {
        return this.startDate == null ? this.inceptionDate : this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public float getStartAUM() {
        return this.startAUM;
    }

    public void setStartAUM(float startAUM) {
        this.startAUM = startAUM;
    }

    public float getEndAUM() {
        return this.endAUM;
    }

    public void setEndAUM(float endAUM) {
        this.endAUM = endAUM;
    }

    public float getMovements() {
        return this.movements;
    }

    public void setMovements(float movements) {
        this.movements = movements;
    }

    public float getPnl() {
        return this.pnl;
    }

    public void setPnl(float pnl) {
        this.pnl = pnl;
    }

    public float getAverageInvestedAUM() {
        return this.averageInvestedAUM;
    }

    public void setAverageInvestedAUM(float averageInvestedAUM) {
        this.averageInvestedAUM = averageInvestedAUM;
    }

    public float getPerformance() {
        return this.performance;
    }

    public void setPerformance(float performance) {
        this.performance = performance;
    }

    public HashMap<String, HashMap<Date, Float>> getTracks() {
        return this.tracks;
    }

    public void setTracks(HashMap<String, HashMap<Date, Float>> tracks) {
        this.tracks = tracks;
    }

    public Breakdown[] getSecurityTypeBreakdown() {
        return this.securityTypeBreakdown;
    }

    public void setSecurityTypeBreakdown(Breakdown[] securityTypeBreakdown) {
        this.securityTypeBreakdown = securityTypeBreakdown;
    }

    public Breakdown[] getCurrencyBreakdown() {
        return this.currencyBreakdown;
    }

    public void setCurrencyBreakdown(Breakdown[] currencyBreakdown) {
        this.currencyBreakdown = currencyBreakdown;
    }

    public float getFxPnl() {
        return this.fxPnl;
    }

    public void setFxPnl(float fxPnl) {
        this.fxPnl = fxPnl;
    }

    public String getMandate() {
        return this.mandate;
    }

    public void setMandate(String mandate) {
        this.mandate = mandate;
    }

    public Account[] getAccounts() {
        return this.accounts;
    }

    public void setAccounts(Account[] accounts) {
        this.accounts = accounts;
    }

    public Position[] getCurrentPositions() {
        return this.currentPositions;
    }

    public Position[] getPositionsByWeight() {
        Position[] workingArray = (Position[])this.currentPositions.clone();
        Arrays.sort(workingArray, Position.descendingWeightComparator);
        return workingArray;
    }

    public void setCurrentPositions(Position[] currentPositions) {
        this.currentPositions = currentPositions;
    }

    public Position[] getSoldPositions() {
        return this.soldPositions;
    }

    public Portfolio[] getSubPortfolios() {
        return this.subPortfolios;
    }

    public void setSubPortfolios(Portfolio[] subPortfolios) {
        this.subPortfolios = subPortfolios;
    }

    public void setSoldPositions(Position[] soldPositions) {
        this.soldPositions = soldPositions;
    }

    public ThirdParty[] getContacts() {
        return this.contacts;
    }

    public void setContacts(ThirdParty[] contacts) {
        this.contacts = contacts;
    }

    public Company getManagementCompany() {
        return this.managementCompany;
    }

    public void setManagementCompany(Company managementCompany) {
        this.managementCompany = managementCompany;
    }

    public ThirdParty getRelationshipManager() {
        return this.relationshipManager;
    }

    public void setRelationshipManager(ThirdParty relationshipManager) {
        this.relationshipManager = relationshipManager;
    }

    public HashMap<Date, MovementDetails> getMovementsDetails() {
        return this.movementsDetails;
    }

    public void setMovementsDetails(HashMap<Date, MovementDetails> movementsDetails) {
        this.movementsDetails = movementsDetails;
    }
}

