/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report.model;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Comparator;

public class Position {
    private String name;
    private String code;
    private String currency;
    private String bloomberg;
    private String type;
    private boolean quantityBased = true;
    private float weight = 0.0f;
    private float spot = 0.0f;
    private float localCurrency = 0.0f;
    private float portfolio = 0.0f;
    private float buyPrice = 0.0f;
    private float price = 0.0f;
    private float quantity = 0.0f;
    private float unrealizedPNL = 0.0f;
    private float unrealizedPerformance = 0.0f;
    private float realizedPNL = 0.0f;
    private float contribution = 0.0f;
    private float fxPerformance = 0.0f;
    private float fxContribution = 0.0f;
    private float globalContribution = 0.0f;
    public static Comparator<Position> descendingWeightComparator = new Comparator<Position>(){

        @Override
        public int compare(Position p1, Position p2) {
            return (int)((p2.getWeight() - p1.getWeight()) * 10000.0f);
        }
    };

    public Position() {
    }

    public Position(JsonNode node) {
        this.name = node.get("name").asText();
        this.code = node.get("code").asText();
        this.bloomberg = node.get("code").asText();
        this.currency = node.get("currency").asText();
        this.type = node.get("type").asText();
        if (node.has("bloomberg")) {
            this.bloomberg = node.get("bloomberg").asText();
        }
        if (node.has("weight")) {
            this.weight = new Float(node.get("weight").asDouble()).floatValue();
            this.spot = new Float(node.get("spot").asDouble()).floatValue();
            this.localCurrency = new Float(node.get("local_currency").asDouble()).floatValue();
            this.portfolio = new Float(node.get("portfolio").asDouble()).floatValue();
        }
        if (node.has("buy_price")) {
            this.buyPrice = new Float(node.get("buy_price").asDouble()).floatValue();
            this.price = new Float(node.get("price").asDouble()).floatValue();
            this.quantity = new Float(node.get("quantity").asDouble()).floatValue();
            this.unrealizedPNL = new Float(node.get("unrealized_pnl").asDouble()).floatValue();
            this.unrealizedPerformance = new Float(node.get("unrealized_performance").asDouble()).floatValue();
            this.contribution = new Float(node.get("contribution").asDouble()).floatValue();
            this.realizedPNL = new Float(node.get("realized_pnl").asDouble()).floatValue();
            this.fxContribution = new Float(node.get("fx_contribution").asDouble()).floatValue();
            this.fxPerformance = new Float(node.get("fx_performance").asDouble()).floatValue();
            this.globalContribution = this.contribution + this.fxContribution;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public float getSpot() {
        return this.spot;
    }

    public void setSpot(float spot) {
        this.spot = spot;
    }

    public float getLocalCurrency() {
        return this.localCurrency;
    }

    public void setLocalCurrency(float localCurrency) {
        this.localCurrency = localCurrency;
    }

    public float getPortfolio() {
        return this.portfolio;
    }

    public void setPortfolio(float portfolio) {
        this.portfolio = portfolio;
    }

    public float getBuyPrice() {
        return this.buyPrice;
    }

    public void setBuyPrice(float buyPrice) {
        this.buyPrice = buyPrice;
    }

    public float getPrice() {
        return this.price;
    }

    public void setPrice(float price) {
        this.price = price;
    }

    public float getQuantity() {
        return this.quantity;
    }

    public void setQuantity(float quantity) {
        this.quantity = quantity;
    }

    public float getUnrealizedPNL() {
        return this.unrealizedPNL;
    }

    public void setUnrealizedPNL(float unrealizedPNL) {
        this.unrealizedPNL = unrealizedPNL;
    }

    public float getUnrealizedPerformance() {
        return this.unrealizedPerformance;
    }

    public void setUnrealizedPerformance(float unrealizedPerformance) {
        this.unrealizedPerformance = unrealizedPerformance;
    }

    public float getRealizedPNL() {
        return this.realizedPNL;
    }

    public void setRealizedPNL(float realizedPNL) {
        this.realizedPNL = realizedPNL;
    }

    public float getContribution() {
        return this.contribution;
    }

    public void setContribution(float contribution) {
        this.contribution = contribution;
    }

    public float getFxPerformance() {
        return this.fxPerformance;
    }

    public void setFxPerformance(float fxPerformance) {
        this.fxPerformance = fxPerformance;
    }

    public float getFxContribution() {
        return this.fxContribution;
    }

    public void setFxContribution(float fxContribution) {
        this.fxContribution = fxContribution;
    }

    public float getGlobalContribution() {
        return this.globalContribution;
    }

    public void setGlobalContribution(float globalContribution) {
        this.globalContribution = globalContribution;
    }

    public boolean isQuantityBased() {
        return this.quantityBased;
    }

    public void setQuantityBased(boolean quantityBased) {
        this.quantityBased = quantityBased;
    }

    public String getBloomberg() {
        return this.bloomberg;
    }

    public void setBloomberg(String bloomberg) {
        this.bloomberg = bloomberg;
    }

    public static Position[] fromJsonNode(JsonNode node) {
        ArrayList<Position> pos = new ArrayList<Position>();
        for (JsonNode element : node) {
            pos.add(new Position(element));
        }
        return pos.toArray(new Position[0]);
    }
}

