/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report.model;

import com.fasterxml.jackson.databind.JsonNode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ReportInformation {
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private String pathToLogo;
    private Date startDate;
    private Date workingDate;
    private String reportName;
    private int documentNumber = 0;

    public ReportInformation() {
    }

    public ReportInformation(JsonNode node) {
        this.pathToLogo = node.get("path_to_logo").asText();
        try {
            this.startDate = dateFormatter.parse(node.get("start_date").asText());
            this.workingDate = dateFormatter.parse(node.get("working_date").asText());
            this.reportName = node.has("report_name") ? node.get("report_name").asText() : null;
            this.documentNumber = node.has("document_number") ? node.get("document_number").asInt() : 0;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public String getPathToLogo() {
        return this.pathToLogo;
    }

    public void setPathToLogo(String pathToLogo) {
        this.pathToLogo = pathToLogo;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getWorkingDate() {
        return this.workingDate;
    }

    public void setWorkingDate(Date workingDate) {
        this.workingDate = workingDate;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(int documentNumber) {
        this.documentNumber = documentNumber;
    }
}

