/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.report.utility;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DateUtil {
    public static final int DAYS_IN_YEAR = 365;
    public static final int DAYS_IN_LEAP_YEAR = 366;
    private static Pattern PERIOD_PATTERN = Pattern.compile("(Q[1-4]|H[1-2])");

    private DateUtil() {
    }

    public static Date addOrRemoveDays(Date date, int days) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        gc.add(6, days);
        return gc.getTime();
    }

    public static Date addOneDay(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        gc.add(6, 1);
        return gc.getTime();
    }

    public static Date addOneYear(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        gc.add(1, 1);
        return gc.getTime();
    }

    public static Date removeYears(Date date, int nbYears) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        gc.add(1, -nbYears);
        return gc.getTime();
    }

    public static Date removeOneDay(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        gc.add(6, -1);
        return gc.getTime();
    }

    public static Date addOrRemoveMonths(Date date, int months) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        gc.add(2, months);
        return gc.getTime();
    }

    public static Date addOrRemoveMonthsEOM(Date date, int months) {
        int absMonth = Math.abs(months);
        Date dt = new Date();
        dt.setTime(date.getTime());
        int i = 0;
        while (i < absMonth) {
            dt = months < 0 ? DateUtil.getEndOfPreviousMonth(dt) : DateUtil.getEndOfNextMonth(dt);
            ++i;
        }
        return dt;
    }

    public static Date getBeginOfQuarter(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        while ((calendar.get(2) + 1) % 3 != 1) {
            calendar.add(2, -1);
        }
        return DateUtil.getBeginOfMonth(calendar.getTime());
    }

    public static Date getEndOfQuarter(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        while ((calendar.get(2) + 1) % 3 != 0) {
            calendar.add(2, 1);
        }
        return DateUtil.getEndOfMonth(calendar.getTime());
    }

    public static Date createDate(int year, int month, int day) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        return calendar.getTime();
    }

    public static Date dateAtYearOffset(Date dtpDate, int offset) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dtpDate);
        cal.setLenient(false);
        cal.add(1, offset);
        return cal.getTime();
    }

    public static Date roundToDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(14, 0);
        c.set(13, 0);
        c.set(12, 0);
        c.set(11, 0);
        return c.getTime();
    }

    public static long roundToSecond(long date) {
        return date - date % 1000L;
    }

    public static Date today() {
        return DateUtil.roundToDay(new Date());
    }

    public void main(String[] args) {
        int year = 2004;
        try {
            GregorianCalendar gc = new GregorianCalendar(2004, 0, 11);
            Date dMaDate = gc.getTime();
            System.out.println(dMaDate + " " + DateUtil.getEndOfWeek(dMaDate));
            GregorianCalendar gc2 = new GregorianCalendar(2004, 0, 8);
            Date dMaDate2 = gc2.getTime();
            System.out.println(dMaDate2 + " " + DateUtil.getEndOfWeek(dMaDate2));
            System.out.println(DateUtil.getDifferenceWeeksNumber(dMaDate, dMaDate2));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public static Date getFirstDate(Date d1, Date d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        if (d1.before(d2)) {
            return d1;
        }
        return d2;
    }

    public static Date getLastDate(Date d1, Date d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        if (d1.before(d2)) {
            return d2;
        }
        return d1;
    }

    public static long getDifferenceDaysNumber(Date d1, Date d2) {
        GregorianCalendar c1;
        GregorianCalendar c2;
        GregorianCalendar c1original = new GregorianCalendar();
        c1original.setTime(d1);
        GregorianCalendar c2original = new GregorianCalendar();
        c2original.setTime(d2);
        if (c2original.before(c1original)) {
            c2 = c1original;
            c1 = c2original;
        } else {
            c2 = c2original;
            c1 = c1original;
        }
        int nYearD1 = c1.get(1);
        int nYearD2 = c2.get(1);
        int nNBDaysD1 = c1.get(6);
        int nNBDaysD2 = c2.get(6);
        int nNbDiffDays = 0;
        if (nYearD2 > nYearD1) {
            nNbDiffDays = c1.isLeapYear(nYearD1) ? 366 - nNBDaysD1 : 365 - nNBDaysD1;
            ++nYearD1;
            while (nYearD2 - nYearD1 != 0) {
                nNbDiffDays = c1.isLeapYear(nYearD1) ? (nNbDiffDays += 366) : (nNbDiffDays += 365);
                ++nYearD1;
            }
            nNbDiffDays += nNBDaysD2;
        } else {
            nNbDiffDays = nNBDaysD2 - nNBDaysD1;
        }
        if (c2original.before(c1original)) {
            return -nNbDiffDays;
        }
        return nNbDiffDays;
    }

    public static int getDifferenceMonthsNumber(Date d1, Date d2) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d1);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(d2);
        int nNBMonthsD1 = c1.get(1) * 12 + c1.get(2);
        int nNBMonthsD2 = c2.get(1) * 12 + c2.get(2);
        return nNBMonthsD2 - nNBMonthsD1;
    }

    public static long getDifferenceWeeksNumber(Date d1, Date d2) {
        GregorianCalendar c1;
        GregorianCalendar c2;
        GregorianCalendar c1original = new GregorianCalendar();
        c1original.setTime(d1);
        GregorianCalendar c2original = new GregorianCalendar();
        c2original.setTime(d2);
        if (c2original.before(c1original)) {
            c2 = c1original;
            c1 = c2original;
        } else {
            c2 = c2original;
            c1 = c1original;
        }
        int nYearD1 = c1.get(1);
        int nYearD2 = c2.get(1);
        int nNbDiffWeeks = 0;
        if (c1.get(3) == 1 && c1.get(2) == 11) {
            ++nYearD1;
        }
        if (nYearD2 > nYearD1) {
            nNbDiffWeeks = c1.getActualMaximum(3) - c1.get(3);
            ++nYearD1;
            while (nYearD2 - nYearD1 != 0) {
                nNbDiffWeeks += c1.getActualMaximum(3);
                ++nYearD1;
            }
            nNbDiffWeeks += c2.get(3);
        } else {
            nNbDiffWeeks = c2.get(3) - c1.get(3);
        }
        if (c2original.before(c1original)) {
            return -nNbDiffWeeks;
        }
        return nNbDiffWeeks;
    }

    public static Date getBeginOfMonth(Date dtpDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dtpDate);
        cal.set(cal.get(1), cal.get(2), cal.getActualMinimum(5), cal.get(10), cal.get(12), cal.get(13));
        return cal.getTime();
    }

    public static Date getEndOfMonth(Date dtpDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dtpDate);
        cal.set(cal.get(1), cal.get(2), cal.getActualMaximum(5), cal.get(10), cal.get(12), cal.get(13));
        return cal.getTime();
    }

    public static Date getEndOfNextMonth(Date dtpDate) {
        return DateUtil.getEndOfMonth(DateUtil.addOneDay(DateUtil.getEndOfMonth(dtpDate)));
    }

    public static Date getEndOfNextWeek(Date dtpDate) {
        return DateUtil.getEndOfWeek(DateUtil.addOneDay(DateUtil.getEndOfWeek(dtpDate)));
    }

    public static Date getEndOfPreviousMonth(Date dtpDate) {
        return DateUtil.getPreviousDay(DateUtil.getStartOfMonth(dtpDate));
    }

    public static Date getEndOfPreviousWeek(Date dtpDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dtpDate);
        while (cal.get(7) != 6) {
            cal.add(5, 1);
        }
        cal.add(5, -7);
        return cal.getTime();
    }

    public static Date getStartOfPreviousWeek(Date dtpDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dtpDate);
        while (cal.get(7) != 2) {
            cal.add(5, -1);
        }
        cal.add(5, -7);
        return cal.getTime();
    }

    public static Date getEndOfWeek(Date dtpDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dtpDate);
        while (cal.get(7) != 6) {
            cal.add(5, 1);
        }
        return cal.getTime();
    }

    public static Date getBeginOfYear(Date dtpDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dtpDate);
        cal.set(cal.get(1), cal.getActualMinimum(2), cal.get(5), cal.get(10), cal.get(12), cal.get(13));
        cal.set(cal.get(1), cal.get(2), cal.getActualMinimum(5), cal.get(10), cal.get(12), cal.get(13));
        return cal.getTime();
    }

    public static Date getBeginOfDay(Date dtpDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dtpDate);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static Date getEndOfYear(Date dtpDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dtpDate);
        cal.set(cal.get(1), cal.getActualMaximum(2), cal.get(5), cal.get(10), cal.get(12), cal.get(13));
        cal.set(cal.get(1), cal.get(2), cal.getActualMaximum(5), cal.get(10), cal.get(12), cal.get(13));
        return cal.getTime();
    }

    public static Date getEndOfDay(Date dtpDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dtpDate);
        cal.set(10, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static int getMonth(Date dtpDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dtpDate);
        return cal.get(2) + 1;
    }

    public static Date getPreviousDay(Date dtpDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dtpDate);
        cal.setLenient(false);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date getPreviousMonth(Date dtpDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dtpDate);
        cal.setLenient(false);
        cal.add(2, -1);
        return cal.getTime();
    }

    public static Collection<Date> getRangeOfDatesMonthly(Date from, Date to, boolean moveFromDate, boolean moveToDate) {
        Date startDate = moveFromDate ? DateUtil.getEndOfMonth(from) : from;
        Date endDate = moveToDate ? DateUtil.getEndOfMonth(to) : to;
        ArrayList<Date> dates = new ArrayList<Date>();
        Date currentDate = startDate;
        while (!currentDate.after(endDate)) {
            dates.add(currentDate);
            currentDate = currentDate == startDate && !currentDate.equals(DateUtil.getEndOfMonth(currentDate)) ? DateUtil.getEndOfMonth(currentDate) : DateUtil.getEndOfNextMonth(currentDate);
        }
        return dates;
    }

    public static Date getStartOfMonth(Date dtpDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dtpDate);
        cal.set(cal.get(1), cal.get(2), cal.getActualMinimum(5), cal.get(10), cal.get(12), cal.get(13));
        return cal.getTime();
    }

    public static Date getMiddleOfMonth(Date dtpDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dtpDate);
        cal.set(cal.get(1), cal.get(2), 15, cal.get(10), cal.get(12), cal.get(13));
        return cal.getTime();
    }

    public static int getYear(Date dtpDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dtpDate);
        return cal.get(1);
    }

    public static boolean isAfterLastDayOfMonth(String newDay, String newMonth) {
        int month;
        int day;
        block3: {
            day = -1;
            month = -1;
            try {
                day = Integer.parseInt(newDay);
                month = Integer.parseInt(newMonth);
                if (month != 2 || day <= 29) break block3;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return (month == 4 || month == 6 || month == 9 || month == 11) && day > 30;
    }

    public static boolean isDateInRange(Date date, Date startDate, Date endDate, boolean inclusive) {
        if (inclusive) {
            return date.after(startDate) && date.before(endDate) || date.equals(startDate) || date.equals(endDate);
        }
        return date.after(startDate) && date.before(endDate);
    }

    public static boolean isEOM(Date date) {
        return DateUtil.roundToDay(date).equals(DateUtil.getEndOfMonth(date));
    }

    public static boolean isEOMBusinessDay(Date date) {
        Date eomBD = DateUtil.roundToDay(DateUtil.getEndOfMonth(date));
        if (DateUtil.isSundayDate(eomBD)) {
            eomBD = DateUtil.removeOneDay(eomBD);
        }
        if (DateUtil.isSaturdayDate(eomBD)) {
            eomBD = DateUtil.removeOneDay(eomBD);
        }
        return DateUtil.roundToDay(date).equals(eomBD);
    }

    public static boolean isMondayDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7) == 2;
    }

    public static boolean isTuesdayDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7) == 3;
    }

    public static boolean isWednesdayDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7) == 4;
    }

    public static boolean isThursdayDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7) == 5;
    }

    public static boolean isFridayDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7) == 6;
    }

    public static boolean isSaturdayDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7) == 7;
    }

    public static boolean isSundayDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7) == 1;
    }

    public static Date[] computePeriod(String period, int year) {
        Date[] result = new Date[2];
        Matcher m = PERIOD_PATTERN.matcher(period);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid period " + period);
        }
        String periodType = m.group(1).substring(0, 1);
        int periodNum = Integer.valueOf(m.group(1).substring(1));
        int startMonth = 0;
        int endDay = 0;
        int endMonth = 0;
        if (periodType.equals("Q")) {
            switch (periodNum) {
                case 1: {
                    startMonth = 0;
                    endDay = 31;
                    endMonth = 2;
                    break;
                }
                case 2: {
                    startMonth = 3;
                    endDay = 30;
                    endMonth = 5;
                    break;
                }
                case 3: {
                    startMonth = 6;
                    endDay = 30;
                    endMonth = 8;
                    break;
                }
                case 4: {
                    startMonth = 9;
                    endDay = 31;
                    endMonth = 11;
                }
            }
        } else {
            switch (periodNum) {
                case 1: {
                    startMonth = 0;
                    endDay = 30;
                    endMonth = 5;
                    break;
                }
                case 2: {
                    startMonth = 6;
                    endDay = 31;
                    endMonth = 11;
                }
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.set(year, startMonth, 1, 0, 0, 0);
        result[0] = cal.getTime();
        cal.set(year, endMonth, endDay, 23, 59, 59);
        result[1] = cal.getTime();
        return result;
    }

    public static Date[] getCurrentQuarterForDate(Date date) {
        Date[] result = new Date[2];
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2);
        month = month / 3 * 3;
        Calendar temp = Calendar.getInstance();
        temp.set(cal.get(1), month, 1, 0, 0, 0);
        temp.set(14, 0);
        result[0] = temp.getTime();
        Calendar temp2 = Calendar.getInstance();
        temp2.set(1, temp.get(1));
        temp2.set(2, temp.get(2) + 4);
        temp2.add(14, -1);
        result[1] = temp2.getTime();
        return result;
    }
}

