/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.util.rabbitmq;

import com.gso.config.RabbitConfiguration;
import com.gso.finance.report.config.ReportsConfiguration;
import com.gso.finance.util.rabbitmq.RabbitController;
import com.gso.finance.util.rabbitmq.ReportHttpHandler;
import com.gso.util.rabbitmq.exception.RabbitConfigurationNotSetException;
import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class HTTPController {
    public static final String REPORTS_TAG = "reports";
    public static final String RABBIT_TAG = "rabbit";
    private static Logger LOGGER = Logger.getLogger(HTTPController.class);
    private static HTTPController instance = null;
    private RabbitConfiguration configuration = null;
    private ReportsConfiguration reportsConfiguration = null;
    private String requestQueueName = null;
    private Boolean controllerActive = Boolean.TRUE;

    private HTTPController() {
    }

    public static HTTPController getInstance() {
        if (instance == null) {
            instance = new HTTPController();
        }
        return instance;
    }

    public void start() throws RabbitConfigurationNotSetException, IOException {
        if (this.configuration == null) {
            throw new RabbitConfigurationNotSetException("The configuration has not been set!");
        }
        LOGGER.info((Object)String.format("Starting on port: %s", this.configuration.getPort()));
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(10);
        HttpServer server = HttpServer.create(new InetSocketAddress("localhost", this.configuration.getPort()), 0);
        server.createContext("/report", new ReportHttpHandler());
        server.setExecutor(threadPoolExecutor);
        LOGGER.info((Object)"Entering wait mode");
        server.start();
    }

    public boolean isControllerActive() {
        return this.controllerActive;
    }

    public void setControllerActive(boolean controllerActive) {
        this.controllerActive = controllerActive;
    }

    public HTTPController setConfiguration(RabbitConfiguration configuration) {
        LOGGER.debug((Object)"New configuration has been assigned");
        this.configuration = configuration;
        return this;
    }

    public ReportsConfiguration getReportsConfiguration() {
        return this.reportsConfiguration;
    }

    public void setReportsConfiguration(ReportsConfiguration reportsConfiguration) {
        this.reportsConfiguration = reportsConfiguration;
    }

    public static void configureLogging(CommandLine cli) {
        Level logLevel = Level.INFO;
        String logRabbitFileName = "RabbitMQ-Reports.log";
        boolean console = false;
        if (cli.hasOption("logs_debug")) {
            logLevel = Level.DEBUG;
        }
        if (cli.hasOption("logs_trace")) {
            logLevel = Level.TRACE;
        }
        if (cli.hasOption("console_input")) {
            console = true;
        }
        String logRootPathName = "";
        if (cli.hasOption("logs_path") && !(logRootPathName = cli.getOptionValue("logs_path")).endsWith(File.separator)) {
            logRootPathName = String.valueOf(logRootPathName) + File.separator;
        }
        Logger rootLogger = Logger.getLogger((String)"com.gso");
        rootLogger.setLevel(logLevel);
        if (!console) {
            rootLogger.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%d{dd MMM yy  HH:mm:ss} %-48C{1} %-5p:  %m%n")));
        }
        try {
            rootLogger.addAppender((Appender)new FileAppender((Layout)new PatternLayout("%d{dd MMM yy  HH:mm:ss} %-48C{1} %-5p:  %m%n"), String.valueOf(logRootPathName) + logRabbitFileName, false));
        }
        catch (IOException e) {
            LOGGER.info((Object)"Could not open logging file.", (Throwable)e);
        }
    }

    public static Path getConfigurationFile(CommandLine cli, String configurationTag) {
        if (cli.hasOption("conf_path") && cli.hasOption("conf_" + configurationTag)) {
            return Paths.get(cli.getOptionValue("conf_path"), cli.getOptionValue("conf_" + configurationTag));
        }
        return null;
    }

    public static Options createCommandLineOptions() {
        Options options = new Options();
        options.addOption("conf_path", true, "Path to configuration files");
        options.addOption("conf_rabbit", true, "Name of the RabbitMQ configuration file");
        options.addOption("conf_reports", true, "Name of the RabbitMQ configuration file");
        options.addOption("ui_enable", false, "Activate the graphical user interface");
        options.addOption("console_input", false, "Activate the console user interaction");
        options.addOption("logs_debug", false, "Enable DEBUG level trace logs");
        options.addOption("logs_trace", false, "Enable TRACE level trace logs. Warning: can be really slow and disk space consuming");
        options.addOption("logs_path", true, "Path to logs storage");
        return options;
    }

    public static void main(String[] argv) throws ParseException {
        Options options = HTTPController.createCommandLineOptions();
        BasicParser parser = new BasicParser();
        CommandLine cli = parser.parse(options, argv);
        Path rabbitConfigPath = HTTPController.getConfigurationFile(cli, RABBIT_TAG);
        Path reportsConfigPath = HTTPController.getConfigurationFile(cli, REPORTS_TAG);
        HTTPController.configureLogging(cli);
        boolean canStart = true;
        if (rabbitConfigPath == null || reportsConfigPath == null) {
            canStart = false;
        }
        RabbitConfiguration rabbitConfig = null;
        ReportsConfiguration reportsConfig = null;
        if (canStart) {
            try {
                rabbitConfig = new RabbitConfiguration(Files.newInputStream(rabbitConfigPath, new OpenOption[0]));
                reportsConfig = new ReportsConfiguration(Files.newInputStream(reportsConfigPath, new OpenOption[0]));
            }
            catch (IOException e) {
                LOGGER.error((Object)"One or more configuration files could not be found or opened, please check the command line arguments.");
                canStart = false;
            }
        }
        if (canStart) {
            LOGGER.info((Object)"Setting up HTTP controller for Report");
            HTTPController controller = HTTPController.getInstance().setConfiguration(rabbitConfig);
            controller.setReportsConfiguration(reportsConfig);
            RabbitController rController = RabbitController.getInstance().setConfiguration(rabbitConfig);
            rController.setReportsConfiguration(reportsConfig);
            LOGGER.info((Object)"\tRabbitMQ controller created");
            try {
                LOGGER.info((Object)"Starting HTTP controller");
                controller.start();
                LOGGER.info((Object)"HTTP controller started");
            }
            catch (RabbitConfigurationNotSetException e) {
                LOGGER.error((Object)"The HTTP controller configuration is not set.");
            }
            catch (IOException e) {
                LOGGER.error((Object)"Network or file system error during RabbitMQ client set up.", (Throwable)e);
            }
        } else {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("HTTPController", options);
            return;
        }
    }
}

