/*
 * Decompiled with CFR 0.152.
 */
package com.gso.finance.util.rabbitmq.consumer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.gso.finance.report.MainConstraintsReport;
import com.gso.finance.report.MainFinanceReport;
import com.gso.finance.report.MainFinanceReportSimplified;
import com.gso.finance.report.MainReport;
import com.gso.finance.report.MainSummaryReport;
import com.gso.finance.report.OperationAMLReport;
import com.gso.finance.report.OperationContractNote;
import com.gso.finance.report.PortfolioOperationsClientBilling;
import com.gso.finance.report.config.ReportsConfiguration;
import com.gso.finance.util.rabbitmq.RabbitController;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.QueueingConsumer;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ReportsConsumer
implements Runnable {
    private static Logger LOGGER = Logger.getLogger(RabbitController.class);
    protected RabbitController controller;
    protected QueueingConsumer.Delivery delivery;
    protected Channel channel;
    protected ReportsConfiguration configuration;
    protected long deliveryTag;
    protected long requestTag;

    public ReportsConsumer(QueueingConsumer.Delivery delivery, Channel channel) {
        this.delivery = delivery;
        this.channel = channel;
        this.controller = RabbitController.getInstance();
        this.configuration = this.controller.getReportsConfiguration();
    }

    public long handleDelivery() throws IOException {
        this.deliveryTag = 0L;
        LOGGER.info((Object)"Handling new message for Statistics");
        String routingKey = this.delivery.getEnvelope().getRoutingKey();
        String contentType = this.delivery.getProperties().getContentType();
        this.deliveryTag = this.delivery.getEnvelope().getDeliveryTag();
        LOGGER.info((Object)("Received Statistics message from " + routingKey + " with format " + contentType + " and delivery tag " + this.deliveryTag));
        String requestBody = new String(this.delivery.getBody());
        LOGGER.info((Object)("Request:" + requestBody));
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(requestBody);
        String reportGeneratorName = node.get("report_generator").asText();
        String reportPath = null;
        MainReport reportGenerator = null;
        if (reportGeneratorName.equals("MainFinanceReport")) {
            reportGenerator = new MainFinanceReport();
        } else if (reportGeneratorName.equals("MainConstraintsReport")) {
            reportGenerator = new MainConstraintsReport();
        } else if (reportGeneratorName.equals("MainSummaryReport")) {
            reportGenerator = new MainSummaryReport();
        } else if (reportGeneratorName.equals("MainFinanceReportSimplified")) {
            reportGenerator = new MainFinanceReportSimplified();
        } else if (reportGeneratorName.equals("OperationContractNote")) {
            reportGenerator = new OperationContractNote();
        } else if (reportGeneratorName.equals("PortfolioOperationsClientBilling")) {
            reportGenerator = new PortfolioOperationsClientBilling();
        } else if (reportGeneratorName.equals("OperationAMLDocument")) {
            reportGenerator = new OperationAMLReport();
        }
        if (reportGenerator != null) {
            reportPath = reportGenerator.generateReport(node.get("data"));
        }
        ObjectMapper responseMapper = new ObjectMapper();
        ObjectNode responseNode = responseMapper.createObjectNode();
        responseNode.put("success", true);
        responseNode.put("report_path", reportPath);
        AMQP.BasicProperties newProperties = new AMQP.BasicProperties();
        newProperties = newProperties.builder().correlationId(this.delivery.getProperties().getCorrelationId()).build();
        LOGGER.info((Object)("\tReplying to [" + this.delivery.getProperties().getReplyTo() + "] and correlation key [" + newProperties.getCorrelationId() + "]"));
        this.channel.basicPublish("", this.delivery.getProperties().getReplyTo(), newProperties, responseNode.toString().getBytes());
        this.channel.basicAck(this.deliveryTag, false);
        LOGGER.info((Object)("Statistics response with delivery tag " + this.deliveryTag + " sent"));
        return this.deliveryTag;
    }

    @Override
    public void run() {
        try {
            this.handleDelivery();
        }
        catch (IOException e) {
            LOGGER.error((Object)"A network or file system error occured during request handling", (Throwable)e);
        }
    }
}

